/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.drinks.ColorMixer;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipe;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.TropicraftItems;

public class CocktailItem
extends Item {
    private static final int DEFAULT_COLOR = 15973942;
    private final Drink drink;

    public CocktailItem(Drink drink, Item.Properties properties) {
        super(properties);
        this.drink = drink;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        Drink drink = CocktailItem.getDrink(stack);
        if (drink == Drink.COCKTAIL && stack.m_41782_() && stack.m_41783_().m_128441_("Ingredients")) {
            ListTag ingredients = stack.m_41783_().m_128437_("Ingredients", 10);
            for (int i = 0; i < ingredients.size(); ++i) {
                CompoundTag ingredient = ingredients.m_128728_(i);
                byte id = ingredient.m_128445_("IngredientID");
                Component ingredientName = Ingredient.ingredientsList[id].getDisplayName();
                int ingredientColor = Ingredient.ingredientsList[id].getColor();
                tooltip.add(ingredientName);
            }
        }
    }

    public static int getCocktailColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && !tag.m_128456_() && tag.m_128441_("Color")) {
            return tag.m_128451_("Color");
        }
        return 15973942;
    }

    @Nonnull
    public static ItemStack makeCocktail(MixerRecipe recipe) {
        ItemStack stack = MixerRecipes.getItemStack(recipe.getCraftingResult());
        CompoundTag nbt = new CompoundTag();
        Drink drink = recipe.getCraftingResult();
        nbt.m_128344_("DrinkID", (byte)drink.drinkId);
        ListTag tagList = new ListTag();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : recipe.getIngredients()) {
            CompoundTag ingredientNbt = new CompoundTag();
            ingredientNbt.m_128344_("IngredientID", (byte)ingredient.id);
            tagList.add((Object)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.m_128365_("Ingredients", (Tag)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.m_128405_("Color", color);
        stack.m_41751_(nbt);
        return stack;
    }

    @Nonnull
    public static ItemStack makeCocktail(NonNullList<ItemStack> itemStacks) {
        ItemStack stack = new ItemStack((ItemLike)((ItemEntry)TropicraftItems.COCKTAILS.get((Object)Drink.COCKTAIL)).get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_("DrinkID", (byte)Drink.COCKTAIL.drinkId);
        ListTag tagList = new ListTag();
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (ItemStack ingredientStack : itemStacks) {
            ingredients.addAll(Ingredient.listIngredients(ingredientStack));
        }
        Collections.sort(ingredients);
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            CompoundTag ingredientNbt = new CompoundTag();
            ingredientNbt.m_128344_("IngredientID", (byte)ingredient.id);
            tagList.add((Object)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.m_128365_("Ingredients", (Tag)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.m_128405_("Color", color);
        stack.m_41751_(nbt);
        return stack;
    }

    public static Ingredient[] getIngredients(ItemStack stack) {
        if (!Drink.isDrink(stack.m_41720_()) || !stack.m_41782_()) {
            return new Ingredient[0];
        }
        CompoundTag nbt = stack.m_41783_();
        ListTag tagList = nbt.m_128437_("Ingredients", 10);
        Ingredient[] ingredients = new Ingredient[tagList.size()];
        for (int i = 0; i < tagList.size(); ++i) {
            byte ingredientID = tagList.m_128728_(i).m_128445_("IngredientID");
            ingredients[i] = Ingredient.ingredientsList[ingredientID];
        }
        return ingredients;
    }

    @Nullable
    public static Drink getDrink(ItemStack stack) {
        if (!Drink.isDrink(stack.m_41720_())) {
            return null;
        }
        return ((CocktailItem)stack.m_41720_()).drink;
    }

    public int m_8105_(ItemStack par1ItemStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack onFoodEaten(ItemStack itemstack, Level world, Player player) {
        world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
        for (Ingredient ingredient : CocktailItem.getIngredients(itemstack)) {
            ingredient.onDrink(player);
        }
        Drink drink = CocktailItem.getDrink(itemstack);
        if (drink != null) {
            drink.onDrink(player);
        }
        return new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get());
    }

    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            this.onFoodEaten(stack, worldIn, player);
            Drink drink = CocktailItem.getDrink(stack);
            if (!worldIn.m_46758_(player.m_142538_()) || drink == Drink.PINA_COLADA) {
                // empty if block
            }
            return player.m_150110_().f_35937_ ? stack : new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get());
        }
        return new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        Drink drink = CocktailItem.getDrink(stack);
        if (drink == null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        playerIn.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public Component m_7626_(ItemStack stack) {
        Drink drink = CocktailItem.getDrink(stack);
        if (drink != null) {
            return super.m_7626_(stack).m_6881_().m_130940_(drink.textFormatting).m_130940_(ChatFormatting.BOLD);
        }
        return super.m_7626_(stack);
    }

    public Drink getDrink() {
        return this.drink;
    }
}

