/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ScubaGogglesItem
extends ScubaArmorItem {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"tropicraft");
    private static final RegistryObject<Attribute> UNDERWATER_VISIBILITY = ATTRIBUTES.register("underwater_visibility", () -> new RangedAttribute(TropicraftLangKeys.SCUBA_VISIBILITY_STAT.getKey(), 0.0, -1.0, 1.0));
    private static final AttributeModifier VISIBILITY_BOOST = new AttributeModifier(UUID.fromString("b09a907f-8264-455b-af81-997c06aa2268"), "tropicraft.underwater.visibility", 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
    private final LazyLoadedValue<Multimap<Attribute, AttributeModifier>> boostedModifiers = new LazyLoadedValue(() -> ImmutableMultimap.builder().putAll(super.getAttributeModifiers(EquipmentSlot.HEAD, new ItemStack((ItemLike)this))).put((Object)((Attribute)UNDERWATER_VISIBILITY.get()), (Object)VISIBILITY_BOOST).build());

    public ScubaGogglesItem(ScubaType type, Item.Properties builder) {
        super(type, EquipmentSlot.HEAD, builder);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderWaterFog(EntityViewRenderEvent.FogDensity event) {
        LocalPlayer player;
        Entity entity;
        Camera info = event.getCamera();
        FogType fogType = info.m_167685_();
        if (fogType == FogType.WATER && (entity = info.m_90592_()) instanceof LocalPlayer && (player = (LocalPlayer)entity).m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ScubaGogglesItem) {
            float f = 192.0f;
            f *= Math.max(0.25f, player.m_108639_());
            f = (float)((double)f * 1.25);
            event.setDensity(f);
            event.setCanceled(true);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.HEAD) {
            return (Multimap)this.boostedModifiers.m_13971_();
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

