/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.network.message.MessageTileEntity;

public class MessageAirCompressorInventory
extends MessageTileEntity<AirCompressorBlockEntity> {
    private ItemStack tank = ItemStack.f_41583_;

    public MessageAirCompressorInventory() {
    }

    public MessageAirCompressorInventory(AirCompressorBlockEntity airCompressor) {
        super(airCompressor);
        this.tank = airCompressor.getTankStack();
    }

    public static void encode(MessageAirCompressorInventory message, FriendlyByteBuf buf) {
        MessageTileEntity.encode(message, buf);
        buf.m_130055_(message.tank);
    }

    public static MessageAirCompressorInventory decode(FriendlyByteBuf buf) {
        MessageAirCompressorInventory message = new MessageAirCompressorInventory();
        MessageTileEntity.decode(message, buf);
        message.tank = buf.m_130267_();
        return message;
    }

    public static void handle(MessageAirCompressorInventory message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            AirCompressorBlockEntity compressor = (AirCompressorBlockEntity)message.getClientTileEntity();
            if (compressor != null) {
                if (!message.tank.m_41619_()) {
                    compressor.addTank(message.tank);
                } else {
                    compressor.ejectTank();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

