/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.network.message.MessageTileEntity;

public class MessageMixerInventory
extends MessageTileEntity<DrinkMixerBlockEntity> {
    private NonNullList<ItemStack> inventory;
    private ItemStack result = ItemStack.f_41583_;

    public MessageMixerInventory() {
    }

    public MessageMixerInventory(DrinkMixerBlockEntity mixer) {
        super(mixer);
        this.inventory = mixer.ingredients;
        this.result = mixer.result;
    }

    public static void encode(MessageMixerInventory message, FriendlyByteBuf buf) {
        MessageTileEntity.encode(message, buf);
        buf.writeByte(message.inventory.size());
        for (ItemStack i : message.inventory) {
            buf.m_130055_(i);
        }
        buf.m_130055_(message.result);
    }

    public static MessageMixerInventory decode(FriendlyByteBuf buf) {
        MessageMixerInventory message = new MessageMixerInventory();
        MessageTileEntity.decode(message, buf);
        message.inventory = NonNullList.m_122780_((int)buf.readByte(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < message.inventory.size(); ++i) {
            message.inventory.set(i, (Object)buf.m_130267_());
        }
        message.result = buf.m_130267_();
        return message;
    }

    public static void handle(MessageMixerInventory message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            DrinkMixerBlockEntity mixer = (DrinkMixerBlockEntity)message.getClientTileEntity();
            if (mixer != null) {
                mixer.ingredients = message.inventory;
                mixer.result = message.result;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

