/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.mixin.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.OptionalInt;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.LevelStem;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(targets={"net/minecraft/core/RegistryCodecs$1"})
public class RegistryCodecsMixin<E> {
    @Inject(method={"decode"}, at={@At(value="INVOKE", target="Lnet/minecraft/resources/RegistryOps;registryLoader()Ljava/util/Optional;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private <T> void decode(DynamicOps<T> ops, T input, CallbackInfoReturnable<DataResult<Pair<Registry<E>, T>>> ci, DataResult<Pair<WritableRegistry<E>, T>> decodedRegistry, RegistryOps<T> registryOps) {
        decodedRegistry.result().map(Pair::getFirst).ifPresent(registry -> {
            ResourceKey registryKey = registry.m_123023_();
            if (registryKey == Registry.f_122820_ && registry.m_7745_(TropicraftDimension.ID) == null) {
                this.addDimensions(registryOps, (WritableRegistry<LevelStem>)registry);
            }
        });
    }

    private void addDimensions(RegistryOps<?> ops, WritableRegistry<LevelStem> registry) {
        LevelStem overworld = (LevelStem)registry.m_6246_(LevelStem.f_63971_);
        if (overworld == null) {
            return;
        }
        long seed = overworld.m_63990_().f_212255_;
        LevelStem dimension = TropicraftDimension.createDimension(RegistryCodecsMixin.registryOrThrow(ops, Registry.f_122818_), RegistryCodecsMixin.registryOrThrow(ops, Registry.f_211073_), RegistryCodecsMixin.registryOrThrow(ops, Registry.f_122885_), RegistryCodecsMixin.registryOrThrow(ops, Registry.f_122878_), RegistryCodecsMixin.registryOrThrow(ops, Registry.f_194568_), seed);
        registry.m_203384_(OptionalInt.empty(), TropicraftDimension.DIMENSION, (Object)dimension, Lifecycle.stable());
    }

    private static <T> Registry<T> registryOrThrow(RegistryOps<?> ops, ResourceKey<Registry<T>> key) {
        return (Registry)ops.m_206826_(key).orElseThrow(() -> new IllegalArgumentException("Missing registry for " + String.valueOf(key)));
    }
}

