/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2.stack;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import appeng.util.BlockApiCache;
import java.util.List;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.ae2.stack.HandlerStrategy;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class MekanismStackImportStrategy
implements StackImportStrategy {
    private final List<BlockApiCache<? extends IChemicalHandler>> lookups;
    private final Direction fromSide;

    public MekanismStackImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.lookups = List.of(BlockApiCache.create(MekCapabilities.GAS_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), BlockApiCache.create(MekCapabilities.INFUSION_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), BlockApiCache.create(MekCapabilities.PIGMENT_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), BlockApiCache.create(MekCapabilities.SLURRY_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos));
        this.fromSide = fromSide;
    }

    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled(MekanismKeyType.TYPE)) {
            return false;
        }
        for (BlockApiCache<? extends IChemicalHandler> lookup : this.lookups) {
            IChemicalHandler adjacentHandler = (IChemicalHandler)lookup.find(this.fromSide);
            if (adjacentHandler == null) continue;
            long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)MekanismKeyType.TYPE.getAmountPerOperation();
            IStorageService inv = context.getInternalStorage();
            for (int i = 0; i < adjacentHandler.getTanks(); ++i) {
                long amountForThisResource;
                long amount;
                AEKey resource = HandlerStrategy.getStackInTank(i, adjacentHandler);
                if (resource == null || !context.isInFilter(resource) || (amount = HandlerStrategy.extract(adjacentHandler, resource, amountForThisResource = inv.getInventory().insert(resource, remainingTransferAmount, Actionable.SIMULATE, context.getActionSource()), Actionable.MODULATE)) <= 0L) continue;
                long inserted = inv.getInventory().insert(resource, amount, Actionable.MODULATE, context.getActionSource());
                if (inserted < amount) {
                    AELog.warn((String)"Extracted %dx%s from adjacent storage and voided it because network refused insert", (Object[])new Object[]{amount - inserted, resource});
                }
                long opsUsed = Math.max(1L, inserted / (long)MekanismKeyType.TYPE.getAmountPerOperation());
                context.reduceOperationsRemaining(opsUsed);
            }
            return false;
        }
        return false;
    }
}

