/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.qio;

import appeng.api.config.Actionable;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import java.util.UUID;
import me.ramidzkh.mekae2.AMText;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.inventory.qio.IQIOComponent;
import mekanism.api.inventory.qio.IQIOFrequency;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class QioStorageAdapter<DASHBOARD extends BlockEntity>
implements MEStorage {
    private final DASHBOARD dashboard;
    @Nullable
    private final Direction queriedSide;
    private final IActionSource querySrc;

    public QioStorageAdapter(DASHBOARD dashboard, @Nullable Direction queriedSide, IActionSource querySrc) {
        this.dashboard = dashboard;
        this.queriedSide = queriedSide;
        this.querySrc = querySrc;
    }

    @Nullable
    public IQIOFrequency getFrequency() {
        if (((Direction)this.dashboard.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_() != this.queriedSide) {
            return null;
        }
        IQIOFrequency freq = ((IQIOComponent)this.dashboard).getQIOFrequency();
        if (freq == null || !freq.isValid()) {
            return null;
        }
        ISecurityUtils utils = MekanismAPI.getSecurityUtils();
        SecurityMode securityMode = utils.getSecurityMode(this.dashboard, this.dashboard.m_58904_().m_5776_());
        if (securityMode != SecurityMode.PUBLIC) {
            IGridNode host = this.querySrc.machine().map(IActionHost::getActionableNode).orElse(null);
            if (host == null) {
                return null;
            }
            UUID storageBusOwner = IPlayerRegistry.getMapping((Level)this.dashboard.m_58904_()).getProfileId(host.getOwningPlayerId());
            if (!utils.canAccess(storageBusOwner, this.dashboard, this.dashboard.m_58904_().m_5776_())) {
                return null;
            }
        }
        return freq;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            if (amount > 0L) {
                IQIOFrequency freq = this.getFrequency();
                if (freq == null) {
                    return 0L;
                }
                return freq.massInsert(itemKey.toStack(), amount, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            }
        }
        return 0L;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            if (amount > 0L) {
                IQIOFrequency freq = this.getFrequency();
                if (freq == null) {
                    return 0L;
                }
                return freq.massExtract(itemKey.toStack(), amount, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            }
        }
        return 0L;
    }

    public void getAvailableStacks(KeyCounter out) {
        IQIOFrequency freq = this.getFrequency();
        if (freq == null) {
            return;
        }
        freq.forAllStored((stack, value) -> out.add((AEKey)AEItemKey.of((ItemStack)stack), value));
    }

    public Component getDescription() {
        IQIOFrequency freq = this.getFrequency();
        if (freq == null) {
            throw new IllegalStateException("Unexpected null frequency!");
        }
        return AMText.QIO_FREQUENCY.formatted(freq.getName());
    }
}

