/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.api.common.data;

import java.util.Objects;
import java.util.StringJoiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;

public class GlobalBlockPos
implements INBTSerializable<CompoundTag> {
    protected BlockPos pos;
    protected ResourceKey<Level> dimensionKey;

    public GlobalBlockPos() {
    }

    public GlobalBlockPos(BlockPos pos, ResourceKey<Level> dimensionKey) {
        this.pos = pos;
        this.dimensionKey = dimensionKey;
    }

    public GlobalBlockPos(BlockPos pos, Level level) {
        this.pos = pos;
        this.dimensionKey = level.m_46472_();
    }

    public static GlobalBlockPos from(CompoundTag compound) {
        GlobalBlockPos globalBlockPos = new GlobalBlockPos();
        globalBlockPos.deserializeNBT(compound);
        return globalBlockPos;
    }

    public static GlobalBlockPos from(FriendlyByteBuf buf) {
        GlobalBlockPos globalBlockPos = new GlobalBlockPos();
        globalBlockPos.decode(buf);
        return globalBlockPos;
    }

    public static GlobalBlockPos from(BlockEntity blockEntity) {
        return new GlobalBlockPos(blockEntity.m_58899_(), blockEntity.m_58904_());
    }

    public ResourceKey<Level> getDimensionKey() {
        return this.dimensionKey;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int hashCode() {
        return Objects.hash(this.dimensionKey, this.pos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalBlockPos other = (GlobalBlockPos)obj;
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        return this.dimensionKey.equals(other.dimensionKey);
    }

    public String toString() {
        return new StringJoiner(", ", "[", "]").add(this.dimensionKey.getRegistryName().toString()).add("x=" + this.pos.m_123341_()).add("y=" + this.pos.m_123342_()).add("z=" + this.pos.m_123343_()).toString();
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public CompoundTag write(CompoundTag compound) {
        compound.m_128356_("pos", this.getPos().m_121878_());
        compound.m_128359_("dimension", this.dimensionKey.m_135782_().toString());
        return compound;
    }

    public void read(CompoundTag compound) {
        this.pos = BlockPos.m_122022_((long)compound.m_128454_("pos"));
        this.dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.dimensionKey.m_135782_());
    }

    public void decode(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
    }
}

