/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.GreedyFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.familiar.GreedyFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismModelLayers;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GreedyFamiliarRenderer
extends MobRenderer<GreedyFamiliarEntity, GreedyFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/greedy_familiar.png");

    public GreedyFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GreedyFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_GREEDY)), 0.3f);
        this.m_115326_(new ItemLayer((RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel>)this));
        this.m_115326_(new GreedyFamiliarChest((RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(GreedyFamiliarEntity entity) {
        return TEXTURES;
    }

    public void render(GreedyFamiliarEntity entityIn, float entityYaw, float partialTicks, PoseStack pMatrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        pMatrixStack.m_85836_();
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            pMatrixStack.m_85837_(0.0, -0.25, 0.0);
        }
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, pMatrixStack, bufferIn, packedLightIn);
        pMatrixStack.m_85849_();
    }

    private static class ItemLayer
    extends RenderLayer<GreedyFamiliarEntity, GreedyFamiliarModel> {
        public ItemLayer(RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, GreedyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            boolean hasBlacksmithUpgrade = pLivingEntity.hasBlacksmithUpgrade();
            ItemStack offhand = pLivingEntity.m_21206_();
            if (!hasBlacksmithUpgrade && offhand.m_41619_()) {
                return;
            }
            GreedyFamiliarModel model = (GreedyFamiliarModel)this.m_117386_();
            ItemInHandRenderer renderer = Minecraft.m_91087_().m_91292_();
            pMatrixStack.m_85836_();
            if (hasBlacksmithUpgrade) {
                model.body.m_104299_(pMatrixStack);
                model.rightArm.m_104299_(pMatrixStack);
                pMatrixStack.m_85837_(-0.06, 0.2, -0.1);
                pMatrixStack.m_85845_(new Quaternion(0.0f, 90.0f, -45.0f, true));
                renderer.m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.f_42385_), ItemTransforms.TransformType.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.m_85849_();
            }
            if (!offhand.m_41619_()) {
                pMatrixStack.m_85836_();
                model.body.m_104299_(pMatrixStack);
                model.leftArm.m_104299_(pMatrixStack);
                pMatrixStack.m_85837_(0.06, 0.2, -0.17);
                pMatrixStack.m_85845_(new Quaternion(0.0f, 45.0f, 0.0f, true));
                float size = 0.75f;
                pMatrixStack.m_85841_(size, size, size);
                renderer.m_109322_((LivingEntity)pLivingEntity, offhand, ItemTransforms.TransformType.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.m_85849_();
            }
        }
    }

    private static class GreedyFamiliarChest
    extends RenderLayer<GreedyFamiliarEntity, GreedyFamiliarModel> {
        private static final ResourceLocation CHEST = new ResourceLocation("occultism", "textures/entity/greedy_familiar_chest.png");
        private static final ResourceLocation CHRISTMAS = new ResourceLocation("occultism", "textures/entity/greedy_familiar_christmas.png");

        public GreedyFamiliarChest(RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GreedyFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.m_20145_()) {
                return;
            }
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)(FamiliarUtil.isChristmas() ? CHRISTMAS : CHEST)));
            GreedyFamiliarModel model = (GreedyFamiliarModel)this.m_117386_();
            model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

