/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.CthulhuFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.HeadlessFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.familiar.HeadlessFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismModelLayers;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class HeadlessFamiliarRenderer
extends MobRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("occultism", "textures/entity/headless_familiar.png");

    public HeadlessFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HeadlessFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_HEADLESS)), 0.3f);
        this.m_115326_(new HeadLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.m_115326_(new WeaponLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.m_115326_(new RebuiltLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.m_115326_(new PumpkinLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(HeadlessFamiliarEntity entity) {
        return TEXTURE;
    }

    public void render(HeadlessFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        if (pEntity.isSitting()) {
            pMatrixStack.m_85837_(0.0, -0.12, 0.0);
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    public static class HeadLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        private static Map<EntityType<?>, ResourceLocation> textures;
        private static Map<EntityType<?>, SkullModelBase> skulls;

        public HeadLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> parent) {
            super(parent);
        }

        private static ResourceLocation getTexture(EntityType<?> type) {
            if (textures == null) {
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)EntityType.f_20532_, (Object)DefaultPlayerSkin.m_118626_());
                builder.put((Object)EntityType.f_20524_, (Object)new ResourceLocation("textures/entity/skeleton/skeleton.png"));
                builder.put((Object)EntityType.f_20497_, (Object)new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
                builder.put((Object)EntityType.f_20501_, (Object)new ResourceLocation("textures/entity/zombie/zombie.png"));
                builder.put((Object)EntityType.f_20558_, (Object)new ResourceLocation("textures/entity/creeper/creeper.png"));
                builder.put((Object)EntityType.f_20479_, (Object)new ResourceLocation("textures/entity/spider/spider.png"));
                builder.put((Object)((EntityType)OccultismEntities.CTHULHU_FAMILIAR.get()), (Object)new ResourceLocation("occultism", "textures/entity/cthulhu_familiar.png"));
                textures = builder.build();
            }
            return textures.get(type);
        }

        private static SkullModelBase getHeadModel(EntityType<?> type) {
            if (skulls == null) {
                EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)EntityType.f_20524_, (Object)new SkullModel(entityModels.m_171103_(ModelLayers.f_171240_)));
                builder.put((Object)EntityType.f_20497_, (Object)new SkullModel(entityModels.m_171103_(ModelLayers.f_171219_)));
                builder.put((Object)EntityType.f_20532_, (Object)new SkullModel(entityModels.m_171103_(ModelLayers.f_171163_)));
                builder.put((Object)EntityType.f_20501_, (Object)new SkullModel(entityModels.m_171103_(ModelLayers.f_171224_)));
                builder.put((Object)EntityType.f_20558_, (Object)new SkullModel(entityModels.m_171103_(ModelLayers.f_171130_)));
                builder.put((Object)EntityType.f_20479_, (Object)new SkullModel(entityModels.m_171103_(ModelLayers.f_171245_)));
                builder.put((Object)((EntityType)OccultismEntities.CTHULHU_FAMILIAR.get()), (Object)new CthulhuHeadModel(entityModels.m_171103_(OccultismModelLayers.FAMILIAR_CTHULHU)));
                skulls = builder.build();
            }
            return skulls.get(type);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, HeadlessFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isHeadlessDead()) {
                return;
            }
            EntityType<? extends LivingEntity> headType = pLivingEntity.getHeadType();
            if (headType == null) {
                return;
            }
            SkullModelBase head = HeadLayer.getHeadModel(headType);
            if (head == null) {
                return;
            }
            pMatrixStack.m_85836_();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.m_117386_();
            model.ratBody1.m_104299_(pMatrixStack);
            model.body.m_104299_(pMatrixStack);
            model.leftArm.m_104299_(pMatrixStack);
            float size = 0.5f;
            pMatrixStack.m_85841_(size, size, size);
            pMatrixStack.m_85837_(0.15, 0.5, -0.12);
            pMatrixStack.m_85845_(new Quaternion(90.0f, 0.0f, 0.0f, true));
            ResourceLocation texture = HeadLayer.getTexture(headType);
            if (texture != null) {
                VertexConsumer builder = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
                head.m_7695_(pMatrixStack, builder, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            pMatrixStack.m_85849_();
        }
    }

    private static class WeaponLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        public WeaponLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, HeadlessFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isHeadlessDead()) {
                return;
            }
            pMatrixStack.m_85836_();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.m_117386_();
            model.ratBody1.m_104299_(pMatrixStack);
            model.body.m_104299_(pMatrixStack);
            model.rightArm.m_104299_(pMatrixStack);
            pMatrixStack.m_85837_((double)-0.05f, 0.16, -0.08);
            pMatrixStack.m_85845_(new Quaternion(0.0f, 90.0f, -50.0f, true));
            Minecraft.m_91087_().m_91292_().m_109322_((LivingEntity)pLivingEntity, pLivingEntity.getWeaponItem(), ItemTransforms.TransformType.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.m_85849_();
        }
    }

    private static class RebuiltLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        public RebuiltLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack matrix, MultiBufferSource bufferIn, int packedLightIn, HeadlessFamiliarEntity headless, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float ageInTicks, float netHeadYaw, float pHeadPitch) {
            if (!headless.isHeadlessDead()) {
                return;
            }
            ItemInHandRenderer renderer = Minecraft.m_91087_().m_91292_();
            matrix.m_85836_();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.m_117386_();
            model.ratBody1.m_104299_(matrix);
            boolean partying = headless.isPartying();
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.RightLeg)) {
                matrix.m_85836_();
                matrix.m_85845_(new Quaternion(0.0f, 130.0f, 0.0f, true));
                matrix.m_85837_(0.3, -0.3, 0.0);
                this.renderItem(Items.f_42405_, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.m_85849_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.LeftLeg)) {
                matrix.m_85836_();
                matrix.m_85845_(new Quaternion(0.0f, 50.0f, 0.0f, true));
                matrix.m_85837_(0.3, -0.3, 0.0);
                this.renderItem(Items.f_42405_, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.m_85849_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.Body)) {
                matrix.m_85836_();
                float size = 1.2f;
                matrix.m_85841_(size, size, size);
                matrix.m_85845_(new Quaternion(0.0f, 0.0f, 0.0f, true));
                matrix.m_85837_(0.0, -0.45, -0.05);
                this.renderItem(Items.f_42129_, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.m_85837_(0.0, -0.25, 0.0);
                this.renderItem(Items.f_42129_, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.m_85849_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.RightArm)) {
                matrix.m_85836_();
                matrix.m_85845_(new Quaternion(0.0f, 180.0f + (partying ? Mth.m_14031_((float)(ageInTicks / 3.0f)) * 20.0f : 0.0f), 0.0f, true));
                matrix.m_85837_(0.25, -0.6, 0.05);
                this.renderItem(Items.f_42398_, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.m_85849_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.LeftArm)) {
                matrix.m_85836_();
                matrix.m_85845_(new Quaternion(0.0f, partying ? Mth.m_14031_((float)(ageInTicks / 3.0f)) * 20.0f : 0.0f, 0.0f, true));
                matrix.m_85837_(0.25, -0.6, -0.05);
                this.renderItem(Items.f_42398_, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.m_85849_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.Head)) {
                matrix.m_85836_();
                matrix.m_85841_(-1.0f, -1.0f, 1.0f);
                matrix.m_85837_(0.0, 0.7, -0.06);
                matrix.m_85845_(new Quaternion(0.0f, partying ? ageInTicks * 8.0f : -netHeadYaw, 0.0f, true));
                this.renderItem(Items.f_42047_, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.m_85849_();
            }
            matrix.m_85849_();
        }

        private void renderItem(Item item, PoseStack pMatrixStack, MultiBufferSource bufferIn, int packedLightIn, HeadlessFamiliarEntity pLivingEntity, ItemInHandRenderer renderer) {
            renderer.m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)item), ItemTransforms.TransformType.GROUND, false, pMatrixStack, bufferIn, packedLightIn);
        }
    }

    private static class PumpkinLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        private static final ResourceLocation PUMPKIN = new ResourceLocation("occultism", "textures/entity/headless_familiar_pumpkin.png");
        private static final ResourceLocation CHRISTMAS = new ResourceLocation("occultism", "textures/entity/headless_familiar_christmas.png");

        public PumpkinLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, HeadlessFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.m_20145_()) {
                return;
            }
            boolean isChristmas = FamiliarUtil.isChristmas();
            boolean hasPumpkin = !entitylivingbaseIn.hasHead();
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)(isChristmas ? CHRISTMAS : PUMPKIN)));
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.m_117386_();
            model.pumpkin1.f_104207_ = hasPumpkin;
            model.snowmanHat1.f_104207_ = isChristmas;
            model.snowmanHat2.f_104207_ = isChristmas;
            model.snowmanLeftEye.f_104207_ = isChristmas;
            model.snowmanRightEye.f_104207_ = isChristmas;
            model.snowmanMouth1.f_104207_ = isChristmas;
            model.snowmanMouth2.f_104207_ = isChristmas;
            model.snowmanMouth3.f_104207_ = isChristmas;
            model.snowmanNose.f_104207_ = isChristmas;
            model.pumpkin2.f_104207_ = !isChristmas;
            model.pumpkin3.f_104207_ = !isChristmas;
            model.pumpkin4.f_104207_ = !isChristmas;
            model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static class CthulhuHeadModel
    extends SkullModelBase {
        private final CthulhuFamiliarModel model;
        protected final ModelPart head;

        public CthulhuHeadModel(ModelPart part) {
            this.model = new CthulhuFamiliarModel(part);
            this.head = part.m_171324_("body").m_171324_("head");
        }

        public void m_7695_(PoseStack pMatrixStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            this.model.trunk1.f_104207_ = false;
            this.model.trunk2.f_104207_ = false;
            this.model.trunk3.f_104207_ = false;
            this.model.hat1.f_104207_ = false;
            pMatrixStack.m_85836_();
            pMatrixStack.m_85841_(1.5f, 1.5f, 1.5f);
            pMatrixStack.m_85837_(0.0, 0.35, 0.07);
            pMatrixStack.m_85845_(new Quaternion(10.0f, 0.0f, 0.0f, true));
            this.model.head.m_104301_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay);
            pMatrixStack.m_85849_();
        }

        public void m_142698_(float p_103811_, float p_103812_, float p_103813_) {
            this.head.f_104204_ = p_103812_ * ((float)Math.PI / 180);
            this.head.f_104203_ = p_103813_ * ((float)Math.PI / 180);
        }
    }
}

