/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai.behaviour;

import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PickupItemBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double PICKUP_XZ_RANGE_SQUARE = 2.5;
    public static final double PICKUP_Y_RANGE = 16.0;
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26332_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        ItemEntity jobItem = (ItemEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_);
        return Math3DUtil.withinAxisDistances(entity.m_20182_(), jobItem.m_20182_(), 2.5, 16.0, 2.5) && ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)((SpiritEntity)entity).itemStackHandler.orElseThrow(ItemHandlerMissingException::new)), (ItemStack)jobItem.m_32055_(), (boolean)true).m_41613_() < jobItem.m_32055_().m_41613_();
    }

    protected void start(E entity) {
        ItemEntity jobItem = (ItemEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)jobItem, false));
        ItemStack duplicate = jobItem.m_32055_().m_41777_();
        ItemStackHandler handler = (ItemStackHandler)((SpiritEntity)entity).itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)true).m_41613_() < duplicate.m_41613_()) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
            jobItem.m_32055_().m_41764_(remaining.m_41613_());
        }
        BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

