/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai.goal;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.misc.DepositOrder;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ManageMachineGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;
    protected BlockEntity cachedStorageAccessor;
    protected DepositOrder cachedStorageAccessorOrder;
    protected ManageMachineJob job;

    public ManageMachineGoal(SpiritEntity entity, ManageMachineJob job) {
        this.entity = entity;
        this.job = job;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.m_20182_(), Math3DUtil.center(this.targetBlock));
        return this.targetBlock.m_142300_(Direction.m_122364_((double)angle).m_122424_());
    }

    public boolean m_8036_() {
        if (this.entity.m_5448_() != null) {
            return false;
        }
        if (!this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    public boolean m_8045_() {
        return this.targetBlock != null && this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.resetTarget();
    }

    public void m_8037_() {
        if (this.targetBlock != null) {
            if (this.entity.f_19853_.m_7702_(this.targetBlock) != null && this.job.getStorageController() != null) {
                float accessDistance;
                BlockEntity blockEntity = this.entity.f_19853_.m_7702_(this.targetBlock);
                double distance = this.entity.m_20182_().m_82554_(Math3DUtil.center(this.targetBlock));
                if (distance < (double)(accessDistance = 2.2f)) {
                    this.entity.m_21573_().m_26573_();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_7864_(moveTarget, 0), 1.0);
                }
                if (distance < (double)accessDistance && this.canSeeTarget()) {
                    DepositOrder currentOrder = this.job.getCurrentDepositOrder();
                    MachineReference machineReference = this.job.getManagedMachine();
                    if (blockEntity instanceof IStorageControllerProxy && currentOrder != null) {
                        ItemStack itemToExtract = this.job.getStorageController().getItemStack(currentOrder.comparator, currentOrder.amount, true);
                        IItemHandler handler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElseThrow(ItemHandlerMissingException::new);
                        if (!itemToExtract.m_41619_() && ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemToExtract, (boolean)true).m_41619_()) {
                            ItemStack extracted = this.job.getStorageController().getItemStack(currentOrder.comparator, currentOrder.amount, false);
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)extracted, (boolean)false);
                            this.entity.setDepositPosition(machineReference.insertGlobalPos.getPos());
                            this.entity.setDepositFacing(machineReference.insertFacing);
                            this.job.setCurrentDepositOrder(null);
                            this.targetBlock = null;
                        }
                    } else if (this.targetBlock.equals((Object)machineReference.extractGlobalPos.getPos())) {
                        blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.extractFacing).ifPresent(machineHandler -> {
                            IItemHandler entityHandler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElseThrow(ItemHandlerMissingException::new);
                            boolean movedAnyItems = false;
                            for (int i = 0; i < machineHandler.getSlots(); ++i) {
                                ItemStack itemToExtract = machineHandler.extractItem(i, machineHandler.getSlotLimit(i), true);
                                ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)itemToExtract, (boolean)true);
                                if (itemToExtract.m_41619_() || remaining.m_41613_() == itemToExtract.m_41613_()) continue;
                                ItemStack extracted = machineHandler.extractItem(i, itemToExtract.m_41613_() - remaining.m_41613_(), false);
                                ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)extracted, (boolean)false);
                                movedAnyItems = true;
                                if (remaining.m_41613_() > 0) break;
                            }
                            if (movedAnyItems) {
                                BlockEntity storageControllerProxy = this.findClosestStorageProxy();
                                if (storageControllerProxy != null) {
                                    this.entity.setDepositPosition(storageControllerProxy.m_58899_());
                                }
                                this.entity.setDepositFacing(Direction.UP);
                                this.targetBlock = null;
                            }
                        });
                    }
                    this.m_8041_();
                }
            } else {
                this.m_8041_();
            }
        }
    }

    public boolean canSeeTarget() {
        BlockState targetBlockState = this.entity.f_19853_.m_8055_(this.targetBlock);
        ClipContext context = new ClipContext(this.entity.m_20299_(0.0f), Math3DUtil.center(this.targetBlock), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity);
        BlockHitResult rayTrace = this.entity.f_19853_.m_45547_(context);
        if (rayTrace.m_6662_() != HitResult.Type.MISS) {
            BlockPos sidePos = rayTrace.m_82425_();
            BlockPos pos = new BlockPos(rayTrace.m_82450_());
            return this.entity.f_19853_.m_46859_(sidePos) || this.entity.f_19853_.m_46859_(pos) || this.entity.f_19853_.m_7702_(pos) == this.entity.f_19853_.m_7702_(this.targetBlock);
        }
        return true;
    }

    protected BlockEntity findClosestStorageProxy() {
        if (this.cachedStorageAccessor != null && this.cachedStorageAccessorOrder == this.job.getCurrentDepositOrder()) {
            return this.cachedStorageAccessor;
        }
        Level level = this.entity.f_19853_;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos machinePosition = this.job.getManagedMachine().insertGlobalPos.getPos();
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        Stream searchBlocks = BlockPos.m_121990_((BlockPos)machinePosition.m_142082_(-workAreaSize, -workAreaSize / 2, -workAreaSize), (BlockPos)machinePosition.m_142082_(workAreaSize, workAreaSize / 2, workAreaSize));
        searchBlocks.forEachOrdered(pos -> {
            IStorageControllerProxy proxy;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IStorageControllerProxy && (proxy = (IStorageControllerProxy)blockEntity).getLinkedStorageControllerPosition() != null && proxy.getLinkedStorageControllerPosition().equals(this.job.getStorageControllerPosition())) {
                allBlocks.add(pos.m_7949_());
            }
        });
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.cachedStorageAccessor = level.m_7702_((BlockPos)allBlocks.get(0));
            this.cachedStorageAccessorOrder = this.job.getCurrentDepositOrder();
            return this.cachedStorageAccessor;
        }
        return null;
    }

    private boolean startTargetingStorageController(DepositOrder depositOrder, MachineReference machineReference, BlockEntity machine, IStorageController storageController) {
        return machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.insertFacing).map(machineItemHandler -> {
            ItemStack orderStack = storageController.getItemStack(depositOrder.comparator, depositOrder.amount, true);
            if (!orderStack.m_41619_() && ItemHandlerHelper.insertItem((IItemHandler)machineItemHandler, (ItemStack)orderStack, (boolean)true).m_41619_()) {
                BlockEntity storageControllerProxy = this.findClosestStorageProxy();
                if (storageControllerProxy != null) {
                    this.targetBlock = storageControllerProxy.m_58899_();
                    return true;
                }
                this.targetBlock = null;
                return true;
            }
            if (!orderStack.m_41619_()) {
                return false;
            }
            return false;
        }).orElse(false);
    }

    private boolean startTargetingExtractBlockEntity(DepositOrder depositOrder, MachineReference machineReference, BlockEntity extractBlockEntity, IStorageController storageController) {
        return extractBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.extractFacing).map(machineItemHandler -> {
            for (int i = 0; i < machineItemHandler.getSlots(); ++i) {
                if (machineItemHandler.getStackInSlot(i).m_41619_()) continue;
                this.targetBlock = extractBlockEntity.m_58899_();
                return true;
            }
            this.targetBlock = null;
            return false;
        }).orElse(false);
    }

    private void resetTarget() {
        DepositOrder currentOrder = this.job.getCurrentDepositOrder();
        MachineReference machineReference = this.job.getManagedMachine();
        BlockEntity machine = this.job.getManagedMachineBlockEntity();
        BlockEntity extractBlockEntity = this.job.getExtractBlockEntity();
        IStorageController storageController = this.job.getStorageController();
        if (machine != null && extractBlockEntity != null && storageController != null) {
            if (!machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.insertFacing).isPresent() || !extractBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.extractFacing).isPresent()) {
                this.job.setManagedMachine(null);
                this.targetBlock = null;
                return;
            }
            if (currentOrder == null || !this.startTargetingStorageController(currentOrder, machineReference, machine, storageController)) {
                this.startTargetingExtractBlockEntity(currentOrder, machineReference, extractBlockEntity, storageController);
            }
        }
    }
}

