/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.familiar;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.familiar.ResizableFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.familiar.ShubNiggurathFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import com.google.common.collect.ImmutableList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class GoatFamiliarEntity
extends ResizableFamiliarEntity {
    private int shakeHeadTimer;

    public GoatFamiliarEntity(EntityType<? extends GoatFamiliarEntity> type, Level level) {
        super((EntityType<? extends ResizableFamiliarEntity>)type, level);
    }

    public GoatFamiliarEntity(Level worldIn, boolean hasRing, boolean hasBeard, byte size, LivingEntity owner) {
        this((EntityType<? extends GoatFamiliarEntity>)((EntityType)OccultismEntities.GOAT_FAMILIAR.get()), worldIn);
        this.setRing(hasRing);
        this.setBeard(hasBeard);
        this.setSize(size);
        this.setFamiliarOwner(owner);
    }

    public static void ringBell(FamiliarEntity entity) {
        LivingEntity owner = entity.getFamiliarOwner();
        if (owner == null || !entity.hasBlacksmithUpgrade()) {
            return;
        }
        entity.m_5496_(SoundEvents.f_11699_, 1.0f, 1.0f);
        for (Mob e2 : entity.f_19853_.m_6443_(Mob.class, entity.m_142469_().m_82400_(30.0), e -> e.m_6084_() && e.getClassification(false) == MobCategory.MONSTER)) {
            e2.m_6710_(owner);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            --this.shakeHeadTimer;
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (super.m_6469_(pSource, pAmount)) {
            if (pSource.m_7639_() != null) {
                GoatFamiliarEntity.ringBell(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!compound.m_128441_("variants")) {
            this.setRing(compound.m_128471_("hasRing"));
        }
    }

    public boolean hasRing() {
        return this.hasVariant(0);
    }

    private void setRing(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasBeard() {
        return this.hasVariant(1);
    }

    private void setBeard(boolean b) {
        this.setVariant(1, b);
    }

    public boolean isBlack() {
        return this.hasVariant(2);
    }

    private void setBlack(boolean b) {
        this.setVariant(2, b);
    }

    public boolean hasRedEyes() {
        return this.hasVariant(3);
    }

    private void setRedEyes(boolean b) {
        this.setVariant(3, b);
    }

    public boolean hasEvilHorns() {
        return this.hasVariant(4);
    }

    private void setEvilHorns(boolean b) {
        this.setVariant(4, b);
    }

    @Override
    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        boolean isInTransformationBiome;
        ItemStack stack = playerIn.m_21120_(hand);
        boolean bl = isInTransformationBiome = this.isInTransformationBiome((Entity)playerIn) || this.isInTransformationBiome((Entity)this);
        if (this.isTransformItem(stack) && playerIn == this.getFamiliarOwner()) {
            if (isInTransformationBiome) {
                if (stack.m_204117_(Tags.Items.DYES_BLACK)) {
                    this.setBlack(true);
                } else if (stack.m_41720_() == Items.f_42545_) {
                    this.setRedEyes(true);
                } else if (stack.m_41720_() == Items.f_42484_) {
                    this.setEvilHorns(true);
                }
                if (this.shouldTransform()) {
                    OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.SHUB_NIGGURATH_SUMMON);
                    this.transform();
                }
                if (!this.f_19853_.f_46443_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            this.shakeHeadTimer = 20;
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(playerIn, hand);
    }

    private void transform() {
        if (this.f_19853_.f_46443_) {
            float scale = this.m_6134_();
            for (int i = 0; i < 30; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(scale), this.m_20187_() * (double)scale, this.m_20262_(scale), 0.0, 0.0, 0.0);
            }
        } else {
            ShubNiggurathFamiliarEntity shubNiggurath = new ShubNiggurathFamiliarEntity(this.f_19853_, this);
            this.f_19853_.m_7967_((Entity)shubNiggurath);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    boolean isTransformItem(ItemStack stack) {
        return stack.m_204117_(Tags.Items.DYES_BLACK) && !this.isBlack() || stack.m_41720_() == Items.f_42484_ && !this.hasEvilHorns() || stack.m_41720_() == Items.f_42545_ && !this.hasRedEyes();
    }

    boolean shouldTransform() {
        return this.isBlack() && this.hasRedEyes() && this.hasEvilHorns();
    }

    private boolean isInTransformationBiome(Entity entity) {
        return this.f_19853_.m_204166_(entity.m_142538_()).m_203656_(OccultismTags.ALLOWS_SHUB_NIGGURRATH_TRANSFORMATION);
    }

    public float getNeckYRot(float pPartialTick) {
        if (this.shakeHeadTimer <= 0) {
            return 0.0f;
        }
        return Mth.m_14031_((float)(((float)this.shakeHeadTimer - pPartialTick) / 20.0f * (float)Math.PI * 5.0f)) * (float)Math.toRadians(30.0);
    }
}

