/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.job;

import com.github.klikli_dev.occultism.api.common.container.IItemStackComparator;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.DepositItemsBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.FellTreeBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.HandleUnreachableTreeBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.PickupItemBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.ReplantSaplingBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToDepositBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToItemBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToReplantSaplingBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToTreeBehaviour;
import com.github.klikli_dev.occultism.common.entity.ai.sensor.NearestJobItemSensor;
import com.github.klikli_dev.occultism.common.entity.ai.sensor.NearestTreeSensor;
import com.github.klikli_dev.occultism.common.entity.ai.sensor.UnreachableTreeWalkTargetSensor;
import com.github.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.common.misc.ItemTagComparator;
import com.github.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class LumberjackJob
extends SpiritJob {
    protected EntityDimensions lumberJackDimensions;
    protected List<IItemStackComparator> itemsToPickUp = new ArrayList<IItemStackComparator>();

    public LumberjackJob(SpiritEntity entity) {
        super(entity);
        this.lumberJackDimensions = EntityDimensions.m_20395_((float)0.8f, (float)0.8f);
    }

    @Override
    public List<ExtendedSensor<SpiritEntity>> getSensors() {
        return ImmutableList.of(new NearestTreeSensor(), new NearestJobItemSensor(), new UnreachableTreeWalkTargetSensor());
    }

    @Override
    public BrainActivityGroup<SpiritEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTargetSink(8, 8), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new MoveToWalkTarget(), new ReplantSaplingBehaviour(), new DepositItemsBehaviour(), new PickupItemBehaviour(), new FellTreeBehaviour()})});
    }

    @Override
    public BrainActivityGroup<SpiritEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetWalkTargetToReplantSaplingBehaviour(), new SetWalkTargetToDepositBehaviour(), new SetWalkTargetToItemBehaviour(), new SetWalkTargetToTreeBehaviour()}), new HandleUnreachableTreeBehaviour()});
    }

    @Override
    public void handleAdditionalBrainSetup(Brain<SpiritEntity> brain) {
    }

    @Override
    public void onInit() {
        this.entity.m_6210_();
        this.itemsToPickUp.add(new ItemTagComparator((TagKey<Item>)ItemTags.f_13182_));
        this.itemsToPickUp.add(new ItemTagComparator((TagKey<Item>)ItemTags.f_13143_));
        this.itemsToPickUp.add(new ItemTagComparator((TagKey<Item>)ItemTags.f_13180_));
        this.itemsToPickUp.add(new ItemTagComparator(OccultismTags.FRUITS));
        this.itemsToPickUp.add(new ItemStackComparator(new ItemStack((ItemLike)Items.f_42398_), false));
    }

    @Override
    public void cleanup() {
        this.entity.m_6210_();
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        for (IItemStackComparator comparator : this.itemsToPickUp) {
            if (!comparator.matches(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EntityDimensions getDimensions(Pose pPose, EntityDimensions original) {
        return this.lumberJackDimensions;
    }

    @Override
    public void onChangeWorkArea() {
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.NO_TREE_IN_WORK_AREA.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.UNREACHABLE_TREES.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.NON_TREE_LOGS.get());
    }
}

