/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.job;

import com.github.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class TraderJob
extends SpiritJob {
    protected int conversionTimer;
    protected int timeToConvert = 20;
    protected PickupItemsGoal pickupItemsGoal;
    protected SpiritTradeRecipe trade;
    protected int maxTradesPerRound = 4;

    public TraderJob(SpiritEntity entity, ResourceLocation recipeId) {
        super(entity);
        this.setTradeRecipeId(recipeId);
    }

    public int getTimeToConvert() {
        return this.timeToConvert;
    }

    public void setTimeToConvert(int timeToConvert) {
        this.timeToConvert = timeToConvert;
    }

    public void setTradeRecipeId(ResourceLocation recipeId) {
        this.trade = null;
        Optional recipe = this.entity.f_19853_.m_7465_().m_44043_(recipeId);
        recipe.ifPresent(r -> {
            if (r instanceof SpiritTradeRecipe) {
                this.trade = (SpiritTradeRecipe)((Object)r);
            }
        });
    }

    public void setMaxTradesPerRound(int trades) {
        this.maxTradesPerRound = trades;
    }

    @Override
    public void onInit() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.f_21346_.m_25352_(1, (Goal)this.pickupItemsGoal);
    }

    @Override
    public void cleanup() {
        this.entity.f_21346_.m_25363_((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.m_21120_(InteractionHand.MAIN_HAND);
        if (this.trade != null && this.trade.isValid(handHeld)) {
            if (this.entity.f_19853_.m_46467_() % 10L == 0L) {
                Vec3 pos = this.entity.m_20182_();
                ((ServerLevel)this.entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_ + this.entity.f_19853_.f_46441_.nextGaussian() / 3.0, pos.f_82480_ + 0.5, pos.f_82481_ + this.entity.f_19853_.f_46441_.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.entity.f_19853_.m_46467_() % 20L == 0L) {
                ++this.conversionTimer;
            }
            if (this.conversionTimer >= this.getTimeToConvert()) {
                int resultCount;
                this.conversionTimer = 0;
                List<ItemStack> input = Collections.singletonList(handHeld);
                for (resultCount = 0; this.trade.isValid(input) && resultCount < this.maxTradesPerRound; ++resultCount) {
                    input = this.trade.consume(input);
                }
                if (input.isEmpty()) {
                    this.entity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                } else {
                    this.entity.m_21008_(InteractionHand.MAIN_HAND, input.get(0));
                }
                ItemStack converted = this.trade.m_8043_().m_41777_();
                converted.m_41764_(converted.m_41613_() * resultCount);
                if (resultCount > 0) {
                    this.entity.m_5552_(converted, 0.0f);
                    this.onConvert(resultCount);
                }
            }
        } else {
            this.conversionTimer = 0;
        }
        super.update();
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound) {
        compound.m_128405_("timeToConvert", this.timeToConvert);
        compound.m_128405_("conversionTimer", this.conversionTimer);
        compound.m_128405_("maxTradesPerRound", this.maxTradesPerRound);
        if (this.trade != null) {
            compound.m_128359_("spiritTradeId", this.trade.m_6423_().toString());
        }
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound) {
        super.readJobFromNBT(compound);
        this.timeToConvert = compound.m_128451_("timeToConvert");
        this.conversionTimer = compound.m_128451_("conversionTimer");
        this.maxTradesPerRound = compound.m_128451_("maxTradesPerRound");
        if (compound.m_128441_("spiritTradeId")) {
            this.setTradeRecipeId(new ResourceLocation(compound.m_128461_("spiritTradeId")));
        }
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        return !stack.m_41619_() && this.trade.isValid(stack);
    }

    public void onConvert(int count) {
    }
}

