/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.spirit;

import com.github.klikli_dev.occultism.common.entity.spirit.WildHuntWitherSkeletonEntity;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WildHuntSkeletonEntity
extends Skeleton {
    protected Optional<WildHuntWitherSkeletonEntity> master = Optional.empty();

    public WildHuntSkeletonEntity(EntityType<? extends WildHuntSkeletonEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Skeleton.m_32166_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    public void setMaster(WildHuntWitherSkeletonEntity master) {
        this.master = Optional.ofNullable(master);
    }

    protected void m_6851_(DifficultyInstance pDifficulty) {
        super.m_6851_(pDifficulty);
        if (this.f_19796_.nextFloat() <= 0.7f) {
            super.m_6851_(pDifficulty);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
    }

    protected boolean m_8028_() {
        return false;
    }

    protected boolean m_21527_() {
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.master.ifPresent(boss -> boss.notifyMinionDeath(this));
        super.m_142687_(reason);
    }

    public boolean m_6673_(DamageSource source) {
        TagKey<EntityType<?>> wildHuntTag = OccultismTags.WILD_HUNT;
        Entity trueSource = source.m_7639_();
        if (trueSource != null && trueSource.m_6095_().m_204039_(wildHuntTag)) {
            return true;
        }
        Entity immediateSource = source.m_7640_();
        if (immediateSource != null && immediateSource.m_6095_().m_204039_(wildHuntTag)) {
            return true;
        }
        return super.m_6673_(source);
    }
}

