/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.spirit;

import com.github.klikli_dev.occultism.common.entity.spirit.WildHuntSkeletonEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

public class WildHuntWitherSkeletonEntity
extends WitherSkeleton {
    List<WildHuntSkeletonEntity> minions = new ArrayList<WildHuntSkeletonEntity>();

    public WildHuntWitherSkeletonEntity(EntityType<? extends WildHuntWitherSkeletonEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WitherSkeleton.m_32166_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22276_, 60.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int maxSkeletons = 3 + level.m_5822_().nextInt(6);
        for (int i = 0; i < maxSkeletons; ++i) {
            WildHuntSkeletonEntity entity = (WildHuntSkeletonEntity)((EntityType)OccultismEntities.WILD_HUNT_SKELETON.get()).m_20615_(this.f_19853_);
            if (!ForgeEventFactory.doSpecialSpawn((Mob)entity, (LevelAccessor)level, (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), null, (MobSpawnType)reason)) {
                entity.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
            }
            double offsetX = level.m_5822_().nextGaussian() * (double)(1 + level.m_5822_().nextInt(4));
            double offsetZ = level.m_5822_().nextGaussian() * (double)(1 + level.m_5822_().nextInt(4));
            entity.m_19890_((double)this.m_146903_() + offsetX, (double)this.m_146904_() + 1.5, (double)this.m_146907_() + offsetZ, level.m_5822_().nextInt(360), 0.0f);
            entity.m_6593_((Component)new TextComponent(TextUtil.generateName()));
            level.m_7967_((Entity)entity);
            entity.setMaster(this);
            this.minions.add(entity);
        }
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean m_8028_() {
        return false;
    }

    protected boolean m_21527_() {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        TagKey<EntityType<?>> wildHuntTag = OccultismTags.WILD_HUNT;
        Entity trueSource = source.m_7639_();
        if (trueSource != null && trueSource.m_6095_().m_204039_(wildHuntTag)) {
            return true;
        }
        Entity immediateSource = source.m_7640_();
        if (immediateSource != null && immediateSource.m_6095_().m_204039_(wildHuntTag)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_20147_() {
        return !this.minions.isEmpty() || super.m_20147_();
    }

    public void notifyMinionDeath(WildHuntSkeletonEntity minion) {
        this.minions.remove((Object)minion);
    }
}

