/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.client.divination.ScanManager;
import com.github.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.github.klikli_dev.occultism.integration.theurgy.TheurgyIntegration;
import com.github.klikli_dev.occultism.network.MessageSetDivinationResult;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DivinationRodItem
extends Item {
    public static final float NOT_FOUND = 7.0f;
    public static final float SEARCHING = 8.0f;

    public DivinationRodItem(Item.Properties properties) {
        super(properties);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entityLiving, int count) {
        if (entityLiving.f_19853_.f_46443_ && entityLiving instanceof Player) {
            ScanManager.instance.updateScan((Player)entityLiving, false);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (player.m_6144_() && !(state = level.m_8055_(pos)).m_60795_()) {
            Block block = this.getOtherBlock(state, player.m_7500_());
            if (block != null) {
                if (!level.f_46443_) {
                    String translationKey = block instanceof IOtherworldBlock ? ((IOtherworldBlock)block).getUncoveredBlock().m_7705_() : block.m_7705_();
                    stack.m_41784_().m_128359_("occultism:divination.linked_block_id", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
                    player.m_6352_((Component)new TranslatableComponent(this.m_5524_() + ".message.linked_block", new Object[]{new TranslatableComponent(translationKey)}), Util.f_137441_);
                }
                level.m_5594_(player, player.m_142538_(), (SoundEvent)OccultismSounds.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (!level.f_46443_) {
                player.m_6352_((Component)new TranslatableComponent(this.m_5524_() + ".message.no_link_found"), Util.f_137441_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            if (stack.m_41784_().m_128441_("occultism:divination.linked_block_id")) {
                stack.m_41783_().m_128350_("occultism:divination.distance", 8.0f);
                player.m_6672_(hand);
                level.m_5594_(player, player.m_142538_(), (SoundEvent)OccultismSounds.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (level.f_46443_) {
                    ResourceLocation id = new ResourceLocation(stack.m_41783_().m_128461_("occultism:divination.linked_block_id"));
                    ScanManager.instance.beginScan(player, (Block)ForgeRegistries.BLOCKS.getValue(id));
                }
            } else if (!level.f_46443_) {
                player.m_6352_((Component)new TranslatableComponent(this.m_5524_() + ".message.no_linked_block"), Util.f_137441_);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        player.m_36335_().m_41524_((Item)this, 40);
        stack.m_41784_().m_128350_("occultism:divination.distance", 7.0f);
        if (level.f_46443_) {
            BlockPos result = ScanManager.instance.finishScan(player);
            float distance = this.getDistance(player.m_20182_(), result);
            stack.m_41783_().m_128350_("occultism:divination.distance", distance);
            OccultismPackets.sendToServer(new MessageSetDivinationResult(result, distance));
            if (result != null) {
                stack.m_41783_().m_128356_("occultism:divination.pos", result.m_121878_());
                if (TheurgyIntegration.isLoaded()) {
                    TheurgyIntegration.spawnDivinationResultParticle(result, level, entityLiving);
                } else {
                    Occultism.SELECTED_BLOCK_RENDERER.selectBlock(result, System.currentTimeMillis() + 10000L);
                }
            }
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity pLivingEntity, int pTimeCharged) {
        BlockPos result;
        if (!stack.m_41784_().m_128441_("occultism:divination.pos")) {
            stack.m_41784_().m_128350_("occultism:divination.distance", 7.0f);
        } else {
            result = BlockPos.m_122022_((long)stack.m_41783_().m_128454_("occultism:divination.pos"));
            float distance = this.getDistance(pLivingEntity.m_20182_(), result);
            stack.m_41783_().m_128350_("occultism:divination.distance", distance);
        }
        if (level.f_46443_) {
            ScanManager.instance.cancelScan();
            if (stack.m_41783_().m_128441_("occultism:divination.pos")) {
                result = BlockPos.m_122022_((long)stack.m_41783_().m_128454_("occultism:divination.pos"));
                if (TheurgyIntegration.isLoaded()) {
                    TheurgyIntegration.spawnDivinationResultParticle(result, level, pLivingEntity);
                } else {
                    Occultism.SELECTED_BLOCK_RENDERER.selectBlock(result, System.currentTimeMillis() + 10000L);
                }
            }
        }
        super.m_5551_(stack, level, pLivingEntity, pTimeCharged);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41784_().m_128441_("occultism:divination.linked_block_id")) {
            ResourceLocation id = new ResourceLocation(stack.m_41783_().m_128461_("occultism:divination.linked_block_id"));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            String translationKey = block instanceof IOtherworldBlock ? ((IOtherworldBlock)block).getUncoveredBlock().m_7705_() : block.m_7705_();
            tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip.linked_block", new Object[]{new TranslatableComponent(translationKey).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.ITALIC})}));
        } else {
            tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip.no_linked_block"));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public Block getOtherBlock(BlockState state, boolean isCreative) {
        if (state.m_60734_() == Blocks.f_50334_ || state.m_60734_() == OccultismBlocks.OTHERSTONE_NATURAL.get() || state.m_60734_() == OccultismBlocks.OTHERSTONE.get()) {
            return (Block)OccultismBlocks.OTHERSTONE_NATURAL.get();
        }
        if (state.m_60734_() == Blocks.f_49999_ || state.m_60734_() == OccultismBlocks.OTHERWORLD_LOG_NATURAL.get() || state.m_60734_() == OccultismBlocks.OTHERWORLD_LOG.get()) {
            return (Block)OccultismBlocks.OTHERWORLD_LOG_NATURAL.get();
        }
        if (state.m_60734_() == Blocks.f_50050_ || state.m_60734_() == OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get() || state.m_60734_() == OccultismBlocks.OTHERWORLD_LEAVES.get()) {
            return (Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get();
        }
        if (state.m_60734_() == Blocks.f_50134_ || state.m_60734_() == OccultismBlocks.IESNIUM_ORE_NATURAL.get() || state.m_60734_() == OccultismBlocks.IESNIUM_ORE.get()) {
            return (Block)OccultismBlocks.IESNIUM_ORE_NATURAL.get();
        }
        return isCreative ? state.m_60734_() : null;
    }

    public float getDistance(Vec3 playerPosition, BlockPos result) {
        if (result == null) {
            return 7.0f;
        }
        Vec3 resultCenter = Math3DUtil.center(result);
        Vec3 playerPosition2d = new Vec3(playerPosition.f_82479_, 0.0, playerPosition.f_82481_);
        Vec3 resultCenter2d = new Vec3(resultCenter.f_82479_, 0.0, resultCenter.f_82481_);
        double distance = playerPosition2d.m_82554_(resultCenter2d);
        if (distance < 6.0) {
            return 0.0f;
        }
        if (distance < 15.0) {
            return 1.0f;
        }
        if (distance < 25.0) {
            return 2.0f;
        }
        if (distance < 35.0) {
            return 3.0f;
        }
        if (distance < 45.0) {
            return 4.0f;
        }
        if (distance < 65.0) {
            return 5.0f;
        }
        return 6.0f;
    }
}

