/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class GuideBookItem
extends Item {
    public static final ResourceLocation DICTIONARY_OF_SPIRITS = new ResourceLocation("occultism", "dictionary_of_spirits");
    protected static Field craftingRemainingItemField = ObfuscationReflectionHelper.findField(Item.class, (String)"f_41378_");

    public GuideBookItem(Item.Properties properties) {
        super(properties);
        try {
            craftingRemainingItemField.set((Object)this, (Object)this);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.m_41777_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            if (itemInHand.m_41782_()) {
                Book book = BookDataManager.get().getBook(DICTIONARY_OF_SPIRITS);
                BookGuiManager.get().openBook(book.getId());
            } else {
                Modonomicon.LOGGER.error("ModonomiconItem: ItemStack has no tag!");
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)pLevel.f_46443_);
    }

    public Component m_7626_(ItemStack pStack) {
        Book book = BookDataManager.get().getBook(DICTIONARY_OF_SPIRITS);
        if (book != null) {
            return new TranslatableComponent(book.getName());
        }
        return super.m_7626_(pStack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Book book = BookDataManager.get().getBook(DICTIONARY_OF_SPIRITS);
        if (book != null) {
            if (flagIn.m_7050_()) {
                tooltip.add((Component)new TextComponent("Book ID: ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TextComponent(book.getId().toString()).m_130940_(ChatFormatting.RED)));
            }
            if (!book.getTooltip().isBlank()) {
                tooltip.add((Component)new TranslatableComponent(book.getTooltip()).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.modonomicon.no_book_found_for_stack", new Object[]{!stack.m_41782_() ? new TextComponent("{}") : NbtUtils.m_178061_((Tag)stack.m_41783_())}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            CompoundTag cmp = new CompoundTag();
            cmp.m_128359_("modonomicon:book_id", DICTIONARY_OF_SPIRITS.toString());
            stack.m_41751_(cmp);
            items.add((Object)stack);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41784_().m_128359_("modonomicon:book_id", DICTIONARY_OF_SPIRITS.toString());
        return super.initCapabilities(stack, nbt);
    }
}

