/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.misc;

import com.github.klikli_dev.occultism.integration.almostunified.AlmostUnifiedIntegration;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class OutputIngredient {
    protected Ingredient ingredient;
    protected ItemStack outputStackInfo;
    protected ItemStack cachedOutputStack;

    public OutputIngredient(Ingredient ingredient) {
        this(ingredient, new ItemStack((ItemLike)Items.f_42329_, 1));
    }

    public OutputIngredient(Ingredient ingredient, ItemStack outputStackInfo) {
        this.ingredient = ingredient;
        this.outputStackInfo = outputStackInfo;
    }

    public ItemStack getStack() {
        if (this.cachedOutputStack == null) {
            ItemStack[] itemStacks = (ItemStack[])Arrays.stream(this.ingredient.f_43902_).flatMap(value -> {
                if (value instanceof Ingredient.TagValue) {
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                    Item item = AlmostUnifiedIntegration.getPreferredItemForTag((TagKey<Item>)tagValue.f_43959_);
                    if (item == null) {
                        item = Registry.f_122827_.m_203431_(tagValue.f_43959_).map(HolderSet.ListBacked::m_203614_).flatMap(Stream::findFirst).map(Holder::m_203334_).orElse(null);
                    }
                    if (item != null) {
                        return Stream.of(new ItemStack((ItemLike)item));
                    }
                    return Stream.of(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)new TextComponent("Empty Tag: " + tagValue.f_43959_.f_203868_())));
                }
                return value.m_6223_().stream();
            }).distinct().toArray(ItemStack[]::new);
            ItemStack outputStack = itemStacks[0].m_41777_();
            outputStack.m_41764_(this.outputStackInfo.m_41613_());
            outputStack.m_41751_(this.outputStackInfo.m_41783_());
            this.cachedOutputStack = outputStack;
        }
        return this.cachedOutputStack;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getOutputStackInfo() {
        return this.outputStackInfo;
    }
}

