/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual;

import com.github.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.ritual.Ritual;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;

public class SummonRitual
extends Ritual {
    private final boolean tame;

    public SummonRitual(RitualRecipe recipe, boolean tame) {
        super(recipe);
        this.tame = tame;
    }

    public ItemStack getBookOfCallingBound(ItemStack activationItem) {
        ItemStack result = this.recipe.m_8043_().m_41777_();
        if (result.m_41720_() == OccultismItems.JEI_DUMMY_NONE.get()) {
            return ItemStack.f_41583_;
        }
        if (activationItem.m_41782_()) {
            result.m_41751_(activationItem.m_41783_().m_6426_());
        }
        return result;
    }

    public void finishBookOfCallingSetup(ItemStack bookOfCalling, SpiritEntity spirit, Player player) {
        ItemNBTUtil.setSpiritEntityUUID(bookOfCalling, spirit.m_142081_());
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)bookOfCalling);
    }

    public void spawnEntity(Entity entity, Level level) {
        for (ServerPlayer player : level.m_45976_(ServerPlayer.class, entity.m_142469_().m_82400_(50.0))) {
            CriteriaTriggers.f_10580_.m_68256_(player, entity);
        }
        level.m_7967_(entity);
    }

    public void applyEntityNbt(Entity entity) {
        if (this.recipe.getEntityNbt() != null) {
            CompoundTag tag = entity.m_20240_(new CompoundTag());
            tag.m_128391_(this.recipe.getEntityNbt());
            entity.m_20258_(tag);
        }
    }

    @Override
    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack activationItem) {
        Entity entity;
        super.finish(level, goldenBowlPosition, blockEntity, castingPlayer, activationItem);
        ItemStack copy = activationItem.m_41777_();
        ItemStack result = this.getBookOfCallingBound(activationItem);
        activationItem.m_41774_(1);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)goldenBowlPosition.m_123341_() + 0.5, (double)goldenBowlPosition.m_123342_() + 0.5, (double)goldenBowlPosition.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        EntityType<?> entityType = this.recipe.getEntityToSummon();
        if (entityType != null && (entity = this.createSummonedEntity(entityType, level, goldenBowlPosition, blockEntity, castingPlayer)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.prepareLivingEntityForSpawn(living, level, goldenBowlPosition, blockEntity, castingPlayer, ItemNBTUtil.getBoundSpiritName(copy), this.tame);
            this.applyEntityNbt((Entity)living);
            this.initSummoned(living, level, goldenBowlPosition, blockEntity, castingPlayer);
            this.spawnEntity((Entity)living, level);
            if (result != ItemStack.f_41583_ && living instanceof SpiritEntity) {
                this.finishBookOfCallingSetup(result, (SpiritEntity)living, castingPlayer);
            }
        }
    }

    public Entity createSummonedEntity(EntityType<?> entityType, Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer) {
        return entityType.m_20615_(level);
    }

    public void initSummoned(LivingEntity living, Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer) {
        if (living instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)living;
            spirit.setSpiritMaxAge(this.recipe.getSpiritMaxAge());
        }
    }

    public void prepareLivingEntityForSpawn(LivingEntity livingEntity, Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, String spiritName, boolean setTamed) {
        Mob mob;
        if (setTamed && livingEntity instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)livingEntity;
            tamableAnimal.m_21828_(castingPlayer);
        }
        livingEntity.m_19890_((double)goldenBowlPosition.m_123341_(), (double)goldenBowlPosition.m_123342_(), (double)goldenBowlPosition.m_123343_(), (float)level.f_46441_.nextInt(360), 0.0f);
        if (spiritName.length() > 0) {
            livingEntity.m_6593_((Component)new TextComponent(spiritName));
        }
        if (livingEntity instanceof Mob && !ForgeEventFactory.doSpecialSpawn((Mob)(mob = (Mob)livingEntity), (LevelAccessor)level, (float)((float)mob.m_20185_()), (float)((float)mob.m_20186_()), (float)((float)mob.m_20189_()), null, (MobSpawnType)MobSpawnType.MOB_SUMMONED)) {
            mob.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(goldenBowlPosition), MobSpawnType.MOB_SUMMONED, null, null);
        }
    }
}

