/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.Occultism;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;

public class MinerRecipeProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public MinerRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    private static void saveRecipe(HashCache pCache, JsonObject pRecipeJson, Path pPath) {
        try {
            String s = GSON.toJson((JsonElement)pRecipeJson);
            String s1 = f_123918_.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(pCache.m_123938_(pPath), s1) || !Files.exists(pPath, new LinkOption[0])) {
                Files.createDirectories(pPath.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pPath, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            pCache.m_123940_(pPath, s1);
        }
        catch (IOException ioexception) {
            Occultism.LOGGER.error("Couldn't save recipe {}", (Object)pPath, (Object)ioexception);
        }
    }

    public void m_6865_(HashCache pOutput) throws IOException {
        HashSet set = Sets.newHashSet();
        Path path = this.generator.m_123916_();
        this.buildRecipes(recipe -> {
            if (!set.add((ResourceLocation)recipe.getFirst())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.getFirst());
            }
            MinerRecipeProvider.saveRecipe(pOutput, (JsonObject)recipe.getSecond(), path.resolve("data/" + ((ResourceLocation)recipe.getFirst()).m_135827_() + "/recipes/miner/" + ((ResourceLocation)recipe.getFirst()).m_135815_() + ".json"));
        });
    }

    protected ResourceLocation modLoc(String path) {
        return new ResourceLocation("occultism", path);
    }

    protected ResourceLocation loc(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    protected void buildRecipes(Consumer<Pair<ResourceLocation, JsonObject>> recipes) {
        this.buildForbiddenArcanusRecipes(recipes);
    }

    protected void buildForbiddenArcanusRecipes(Consumer<Pair<ResourceLocation, JsonObject>> recipes) {
        recipes.accept(this.buildMinerRecipe(this.modLoc("deeps/deepslate_arcane_crystal"), this.modLoc("miners/deeps"), this.loc("forge", "ores/arcane_crystal"), 200));
        recipes.accept(this.buildMinerRecipe(this.modLoc("master/stella_arcanum"), this.modLoc("miners/master"), this.loc("forge", "ores/stella_arcanum"), 100));
        recipes.accept(this.buildMinerRecipe(this.modLoc("ores/arcane_crystal"), this.modLoc("miners/ores"), this.loc("forge", "ores/arcane_crystal"), 200));
        recipes.accept(this.buildMinerRecipe(this.modLoc("ores/xpetrified"), this.modLoc("miners/ores"), this.loc("forge", "ores/xpetrified_ore"), 200));
    }

    protected Pair<ResourceLocation, JsonObject> buildMinerRecipe(ResourceLocation name, ResourceLocation minerTag, ResourceLocation outputTag, int weight) {
        JsonObject recipe = this.buildMinerRecipeJson(minerTag.toString(), outputTag.toString(), weight);
        return new Pair((Object)name, (Object)recipe);
    }

    public JsonObject buildMinerRecipeJson(String minerTag, String outputTag, int weight) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "occultism:miner");
        JsonArray conditions = this.buildMinerRecipeConditionJson(outputTag);
        recipe.add("conditions", (JsonElement)conditions);
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("tag", minerTag);
        recipe.add("ingredient", (JsonElement)ingredient);
        JsonObject result = new JsonObject();
        result.addProperty("tag", outputTag);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("weight", (Number)weight);
        return recipe;
    }

    public JsonArray buildMinerRecipeConditionJson(String outputTag) {
        JsonArray conditions = new JsonArray();
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "forge:not");
        JsonObject value = new JsonObject();
        value.addProperty("type", "forge:tag_empty");
        value.addProperty("tag", outputTag);
        condition.add("value", (JsonElement)value);
        conditions.add((JsonElement)condition);
        return conditions;
    }

    public String m_6055_() {
        return "Miner Recipes";
    }
}

