/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.advancement.RitualTrigger;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.TickTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OccultismAdvancementProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<ResourceLocation, Advancement> advancements;

    public OccultismAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
        this.advancements = new HashMap<ResourceLocation, Advancement>();
    }

    private static TranslatableComponent text(String name, String type) {
        return new TranslatableComponent("advancements.occultism." + name + "." + type);
    }

    public static TranslatableComponent title(String name) {
        return OccultismAdvancementProvider.text(name, "title");
    }

    public static TranslatableComponent descr(String name) {
        return OccultismAdvancementProvider.text(name, "description");
    }

    private static TranslatableComponent familiarText(String name, String type) {
        return new TranslatableComponent("advancements.occultism.familiar." + name + "." + type);
    }

    public static TranslatableComponent familiarTitle(String name) {
        return OccultismAdvancementProvider.familiarText(name, "title");
    }

    public static TranslatableComponent familiarDescr(String name) {
        return OccultismAdvancementProvider.familiarText(name, "description");
    }

    private static Path getPath(Path path, Advancement advancement) {
        ResourceLocation id = advancement.m_138327_();
        return path.resolve("data/" + id.m_135827_() + "/advancements/" + id.m_135815_() + ".json");
    }

    public void m_6865_(HashCache pCache) throws IOException {
        Path folder = this.generator.m_123916_();
        this.start();
        for (Advancement advancement : this.advancements.values()) {
            Path path = OccultismAdvancementProvider.getPath(folder, advancement);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)pCache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path);
            }
            catch (IOException exception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)exception);
            }
        }
    }

    private void start() {
        Advancement root = this.add(Advancement.Builder.m_138353_().m_138386_("occultism_present", (CriterionTriggerInstance)new TickTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).m_138403_(new ResourceLocation("occultism", "occultism/root")));
        Advancement familiarsRoot = this.add(Advancement.Builder.m_138353_().m_138371_((ItemLike)OccultismItems.JEI_DUMMY_NONE.get(), (Component)OccultismAdvancementProvider.title("familiars"), (Component)OccultismAdvancementProvider.descr("familiars"), new ResourceLocation("textures/gui/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false).m_138386_("summon_familiar", (CriterionTriggerInstance)new RitualTrigger.Instance(new RitualTrigger.RitualPredicate(null, OccultismRituals.FAMILIAR_RITUAL.getId()))).m_138403_(new ResourceLocation("occultism", "occultism/familiar/root")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(2), (Component)OccultismAdvancementProvider.familiarTitle("deer"), (Component)OccultismAdvancementProvider.familiarDescr("deer"), null, FrameType.TASK, true, true, false).m_138386_("deer_poop", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DEER_POOP)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/deer")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(0), (Component)OccultismAdvancementProvider.familiarTitle("cthulhu"), (Component)OccultismAdvancementProvider.familiarDescr("cthulhu"), null, FrameType.TASK, true, true, false).m_138386_("cthulhu_sad", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.CTHULHU_SAD)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/cthulhu")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(1), (Component)OccultismAdvancementProvider.familiarTitle("bat"), (Component)OccultismAdvancementProvider.familiarDescr("bat"), null, FrameType.TASK, true, true, false).m_138386_("bat_eat", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BAT_EAT)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/bat")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(3), (Component)OccultismAdvancementProvider.familiarTitle("devil"), (Component)OccultismAdvancementProvider.familiarDescr("devil"), null, FrameType.TASK, true, true, false).m_138386_("devil_fire", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DEVIL_FIRE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/devil")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(4), (Component)OccultismAdvancementProvider.familiarTitle("greedy"), (Component)OccultismAdvancementProvider.familiarDescr("greedy"), null, FrameType.TASK, true, true, false).m_138386_("greedy_item", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.GREEDY_ITEM)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/greedy")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(5), (Component)OccultismAdvancementProvider.familiarTitle("rare"), (Component)OccultismAdvancementProvider.familiarDescr("rare"), null, FrameType.TASK, true, true, false).m_138386_("rare_variant", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.RARE_VARIANT)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/rare")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138371_((ItemLike)Items.f_41984_, (Component)OccultismAdvancementProvider.familiarTitle("party"), (Component)OccultismAdvancementProvider.familiarDescr("party"), null, FrameType.TASK, true, true, false).m_138386_("party", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.PARTY)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/party")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138371_((ItemLike)OccultismItems.FAMILIAR_RING.get(), (Component)OccultismAdvancementProvider.familiarTitle("capture"), (Component)OccultismAdvancementProvider.familiarDescr("capture"), null, FrameType.TASK, true, true, false).m_138386_("capture", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.CAPTURE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/capture")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138371_((ItemLike)Items.f_42587_, (Component)OccultismAdvancementProvider.familiarTitle("dragon_nugget"), (Component)OccultismAdvancementProvider.familiarDescr("dragon_nugget"), null, FrameType.TASK, true, true, false).m_138386_("dragon_nugget", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_NUGGET)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/dragon_nugget")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(6), (Component)OccultismAdvancementProvider.familiarTitle("dragon_ride"), (Component)OccultismAdvancementProvider.familiarDescr("dragon_ride"), null, FrameType.TASK, true, true, false).m_138386_("dragon_ride", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_RIDE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/dragon_ride")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138371_((ItemLike)Items.f_42398_, (Component)OccultismAdvancementProvider.familiarTitle("mans_best_friend"), (Component)OccultismAdvancementProvider.familiarDescr("mans_best_friend"), null, FrameType.TASK, true, true, false).m_138386_("dragon_pet", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_PET)).m_138386_("dragon_fetch", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_FETCH)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/mans_best_friend")));
        this.add(Advancement.Builder.m_138353_().m_138398_(root).m_138362_(this.icon(7), (Component)OccultismAdvancementProvider.familiarTitle("blacksmith_upgrade"), (Component)OccultismAdvancementProvider.familiarDescr("blacksmith_upgrade"), null, FrameType.TASK, true, true, false).m_138386_("blacksmith_upgrade", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BLACKSMITH_UPGRADE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/blacksmith_upgrade")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(8), (Component)OccultismAdvancementProvider.familiarTitle("guardian_ultimate_sacrifice"), (Component)OccultismAdvancementProvider.familiarDescr("guardian_ultimate_sacrifice"), null, FrameType.TASK, true, true, false).m_138386_("guardian_ultimate_sacrifice", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.GUARDIAN_ULTIMATE_SACRIFICE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/guardian_ultimate_sacrifice")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(9), (Component)OccultismAdvancementProvider.familiarTitle("headless_cthulhu_head"), (Component)OccultismAdvancementProvider.familiarDescr("headless_cthulhu_head"), null, FrameType.TASK, true, true, false).m_138386_("headless_cthulhu_head", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.HEADLESS_CTHULHU_HEAD)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/headless_cthulhu_head")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138371_((ItemLike)Items.f_42129_, (Component)OccultismAdvancementProvider.familiarTitle("headless_rebuilt"), (Component)OccultismAdvancementProvider.familiarDescr("headless_rebuilt"), null, FrameType.TASK, true, true, false).m_138386_("headless_rebuilt", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.HEADLESS_REBUILT)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/headless_rebuilt")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(10), (Component)OccultismAdvancementProvider.familiarTitle("chimera_ride"), (Component)OccultismAdvancementProvider.familiarDescr("chimera_ride"), null, FrameType.TASK, true, true, false).m_138386_("chimera_ride", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.CHIMERA_RIDE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/chimera_ride")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138371_((ItemLike)Items.f_42436_, (Component)OccultismAdvancementProvider.familiarTitle("goat_detach"), (Component)OccultismAdvancementProvider.familiarDescr("goat_detach"), null, FrameType.TASK, true, true, false).m_138386_("goat_detach", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.GOAT_DETACH)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/goat_detach")));
        Advancement summonShub = this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(11), (Component)OccultismAdvancementProvider.familiarTitle("shub_niggurath_summon"), (Component)OccultismAdvancementProvider.familiarDescr("shub_niggurath_summon"), null, FrameType.TASK, true, true, false).m_138386_("shub_niggurath_summon", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_NIGGURATH_SUMMON)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/shub_niggurath_summon")));
        this.add(Advancement.Builder.m_138353_().m_138398_(summonShub).m_138371_((ItemLike)Items.f_41940_, (Component)OccultismAdvancementProvider.familiarTitle("shub_cthulhu_friends"), (Component)OccultismAdvancementProvider.familiarDescr("shub_cthulhu_friends"), null, FrameType.TASK, true, true, false).m_138386_("shub_cthulhu_friends", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_CTHULHU_FRIENDS)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/shub_cthulhu_friends")));
        this.add(Advancement.Builder.m_138353_().m_138398_(summonShub).m_138362_(this.icon(12), (Component)OccultismAdvancementProvider.familiarTitle("shub_niggurath_spawn"), (Component)OccultismAdvancementProvider.familiarDescr("shub_niggurath_spawn"), null, FrameType.TASK, true, true, false).m_138386_("shub_niggurath_spawn", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_NIGGURATH_SPAWN)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/shub_niggurath_spawn")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(13), (Component)OccultismAdvancementProvider.familiarTitle("beholder_ray"), (Component)OccultismAdvancementProvider.familiarDescr("beholder_ray"), null, FrameType.TASK, true, true, false).m_138386_("beholder_ray", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BEHOLDER_RAY)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/beholder_ray")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138371_((ItemLike)Items.f_42687_, (Component)OccultismAdvancementProvider.familiarTitle("beholder_eat"), (Component)OccultismAdvancementProvider.familiarDescr("beholder_eat"), null, FrameType.TASK, true, true, false).m_138386_("beholder_eat", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BEHOLDER_EAT)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/beholder_eat")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(14), (Component)OccultismAdvancementProvider.familiarTitle("fairy_save"), (Component)OccultismAdvancementProvider.familiarDescr("fairy_save"), null, FrameType.TASK, true, true, false).m_138386_("fairy_save", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.FAIRY_SAVE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/fairy_save")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(15), (Component)OccultismAdvancementProvider.familiarTitle("mummy_dodge"), (Component)OccultismAdvancementProvider.familiarDescr("mummy_dodge"), null, FrameType.TASK, true, true, false).m_138386_("mummy_dodge", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.MUMMY_DODGE)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/mummy_dodge")));
        this.add(Advancement.Builder.m_138353_().m_138398_(familiarsRoot).m_138362_(this.icon(16), (Component)OccultismAdvancementProvider.familiarTitle("beaver_woodchop"), (Component)OccultismAdvancementProvider.familiarDescr("beaver_woodchop"), null, FrameType.TASK, true, true, false).m_138386_("beaver_woodchop", (CriterionTriggerInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BEAVER_WOODCHOP)).m_138403_(new ResourceLocation("occultism", "occultism/familiar/beaver_woodchop")));
        this.addRitualHidden(root, "craft_dimensional_matrix");
        this.addRitualHidden(root, "craft_dimensional_mineshaft");
        this.addRitualHidden(root, "craft_familiar_ring");
        this.addRitualHidden(root, "craft_infused_lenses");
        this.addRitualHidden(root, "craft_infused_pickaxe");
        this.addRitualHidden(root, "craft_miner_djinni_ores");
        this.addRitualHidden(root, "craft_miner_foliot_unspecialized");
        this.addRitualHidden(root, "craft_miner_afrit_deeps");
        this.addRitualHidden(root, "craft_miner_marid_master");
        this.addRitualHidden(root, "craft_satchel");
        this.addRitualHidden(root, "craft_soul_gem");
        this.addRitualHidden(root, "craft_stabilizer_tier1");
        this.addRitualHidden(root, "craft_stabilizer_tier2");
        this.addRitualHidden(root, "craft_stabilizer_tier3");
        this.addRitualHidden(root, "craft_stabilizer_tier4");
        this.addRitualHidden(root, "craft_stable_wormhole");
        this.addRitualHidden(root, "craft_storage_controller_base");
        this.addRitualHidden(root, "craft_storage_remote");
        this.addRitualHidden(root, "familiar_bat");
        this.addRitualHidden(root, "familiar_cthulhu");
        this.addRitualHidden(root, "familiar_deer");
        this.addRitualHidden(root, "familiar_devil");
        this.addRitualHidden(root, "familiar_dragon");
        this.addRitualHidden(root, "familiar_greedy");
        this.addRitualHidden(root, "familiar_otherworld_bird");
        this.addRitualHidden(root, "familiar_parrot");
        this.addRitualHidden(root, "familiar_guardian");
        this.addRitualHidden(root, "familiar_blacksmith");
        this.addRitualHidden(root, "familiar_headless");
        this.addRitualHidden(root, "familiar_chimera");
        this.addRitualHidden(root, "familiar_beholder");
        this.addRitualHidden(root, "familiar_fairy");
        this.addRitualHidden(root, "familiar_mummy");
        this.addRitualHidden(root, "familiar_beaver");
        this.addRitualHidden(root, "possess_enderman");
        this.addRitualHidden(root, "possess_endermite");
        this.addRitualHidden(root, "possess_skeleton");
        this.addRitualHidden(root, "possess_ghast");
        this.addRitualHidden(root, "summon_afrit_crusher");
        this.addRitualHidden(root, "summon_afrit_rain_weather");
        this.addRitualHidden(root, "summon_afrit_thunder_weather");
        this.addRitualHidden(root, "summon_djinni_clear_weather");
        this.addRitualHidden(root, "summon_djinni_crusher");
        this.addRitualHidden(root, "summon_djinni_day_time");
        this.addRitualHidden(root, "summon_djinni_manage_machine");
        this.addRitualHidden(root, "summon_djinni_night_time");
        this.addRitualHidden(root, "summon_foliot_cleaner");
        this.addRitualHidden(root, "summon_foliot_crusher");
        this.addRitualHidden(root, "summon_foliot_lumberjack");
        this.addRitualHidden(root, "summon_foliot_otherstone_trader");
        this.addRitualHidden(root, "summon_foliot_sapling_trader");
        this.addRitualHidden(root, "summon_foliot_transport_items");
        this.addRitualHidden(root, "summon_marid_crusher");
        this.addRitualHidden(root, "summon_wild_afrit");
        this.addRitualHidden(root, "summon_wild_hunt");
    }

    private Advancement addRitualHidden(Advancement parent, String id) {
        return this.add(Advancement.Builder.m_138353_().m_138398_(parent).m_138371_((ItemLike)OccultismItems.JEI_DUMMY_NONE.get(), (Component)OccultismAdvancementProvider.title(id), (Component)OccultismAdvancementProvider.descr(id), null, FrameType.TASK, false, false, true).m_138386_(id, (CriterionTriggerInstance)new RitualTrigger.Instance(new RitualTrigger.RitualPredicate(new ResourceLocation("occultism", "ritual/" + id), null))).m_138403_(new ResourceLocation("occultism", "occultism/" + id)));
    }

    private ItemStack icon(int data) {
        ItemStack icon = ((Item)OccultismItems.ADVANCEMENT_ICON.get()).m_7968_();
        icon.m_41700_("CustomModelData", (Tag)IntTag.m_128679_((int)data));
        return icon;
    }

    private Advancement add(Advancement advancement) {
        if (this.advancements.containsKey(advancement.m_138327_())) {
            throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
        }
        this.advancements.put(advancement.m_138327_(), advancement);
        return advancement;
    }

    public String m_6055_() {
        return "Advancements: occultism";
    }
}

