/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.block.SpiritFireBlock;
import com.github.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.github.klikli_dev.occultism.common.item.tool.SoulGemItem;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEventHandler {
    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isFireCharge;
        PlayerEventHandler.dancingFamiliars(event);
        boolean isFlintAndSteel = event.getItemStack().m_41720_() == Items.f_42409_;
        boolean bl = isFireCharge = event.getItemStack().m_41720_() == Items.f_42613_;
        if (isFlintAndSteel || isFireCharge) {
            AABB box = new AABB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).m_82383_(Math3DUtil.center(event.getPos()));
            List list = event.getWorld().m_6443_(ItemEntity.class, box, item -> item.m_32055_().m_41720_() == OccultismItems.DATURA.get());
            if (!list.isEmpty()) {
                BlockPos pos = event.getPos().m_142300_(event.getFace());
                if (!event.getPlayer().m_36204_(pos, event.getFace(), event.getItemStack())) {
                    return;
                }
                list.forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
                Level level = event.getWorld();
                if (level.m_46859_(pos)) {
                    SoundEvent soundEvent = isFlintAndSteel ? SoundEvents.f_11942_ : SoundEvents.f_11874_;
                    level.m_5594_(event.getPlayer(), pos, soundEvent, SoundSource.BLOCKS, 1.0f, level.f_46441_.nextFloat() * 0.4f + 0.8f);
                    level.m_7731_(pos, ((SpiritFireBlock)((Object)OccultismBlocks.SPIRIT_FIRE.get())).m_49966_(), 11);
                }
                if (isFlintAndSteel) {
                    event.getItemStack().m_41622_(1, (LivingEntity)event.getPlayer(), player -> player.m_21190_(event.getHand()));
                } else if (isFireCharge) {
                    event.getItemStack().m_41774_(1);
                }
                event.setCanceled(true);
                event.getPlayer().m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }

    private static void dancingFamiliars(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getWorld().m_8055_(event.getPos());
        if (!state.m_61138_((Property)JukeboxBlock.f_54254_) || ((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue() || !(event.getItemStack().m_41720_() instanceof RecordItem)) {
            return;
        }
        if (event.getWorld().m_6443_(Entity.class, new AABB(event.getPos()).m_82400_(3.0), e -> e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == event.getPlayer()).isEmpty()) {
            return;
        }
        OccultismAdvancements.FAMILIAR.trigger((LivingEntity)event.getPlayer(), FamiliarTrigger.Type.PARTY);
    }

    @SubscribeEvent
    public static void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().m_41720_() == OccultismItems.SOUL_GEM_ITEM.get() && event.getTarget() instanceof LivingEntity && ((SoulGemItem)((Object)OccultismItems.SOUL_GEM_ITEM.get())).m_6880_(event.getItemStack(), event.getPlayer(), (LivingEntity)event.getTarget(), event.getHand()) == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }
}

