/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddItemModifier
extends LootModifier {
    private final Item addedItem;
    private final int count;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item addedItemIn, int count) {
        super(conditionsIn);
        this.addedItem = addedItemIn;
        this.count = count;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        generatedLoot.add(new ItemStack((ItemLike)this.addedItem, this.count));
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemModifier> {
        public AddItemModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            Item addedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"item")));
            int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
            return new AddItemModifier(ailootcondition, addedItem, count);
        }

        public JsonObject write(AddItemModifier instance) {
            JsonObject json = new JsonObject();
            json.addProperty("item", instance.addedItem.getRegistryName().toString());
            json.addProperty("count", (Number)instance.count);
            return json;
        }
    }
}

