/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering;

import java.util.HashSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import tfar.davespotioneering.Events;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.block.ModCauldronInteractions;
import tfar.davespotioneering.client.ClientEvents;
import tfar.davespotioneering.datagen.ModDatagen;
import tfar.davespotioneering.effect.PotionIngredient;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.init.ModContainerTypes;
import tfar.davespotioneering.init.ModEffects;
import tfar.davespotioneering.init.ModItems;
import tfar.davespotioneering.init.ModParticleTypes;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.mixin.BlockEntityTypeAcces;
import tfar.davespotioneering.net.PacketHandler;

@Mod(value="davespotioneering")
public class DavesPotioneering {
    public static final String MODID = "davespotioneering";
    public static final boolean DEBUG = !FMLEnvironment.production;
    public static final ModConfig.Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ModConfig.Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public DavesPotioneering() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModDatagen::start);
        bus.addGenericListener(Block.class, ModBlocks::register);
        bus.addGenericListener(Item.class, ModItems::register);
        bus.addGenericListener(MobEffect.class, ModEffects::register);
        bus.addGenericListener(Potion.class, ModPotions::register);
        bus.addGenericListener(BlockEntityType.class, ModBlockEntityTypes::register);
        bus.addGenericListener(MenuType.class, ModContainerTypes::register);
        bus.addGenericListener(SoundEvent.class, ModSoundEvents::register);
        bus.addGenericListener(ParticleType.class, ModParticleTypes::register);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        bus.addListener(this::setup);
        bus.addListener(this::stackAdj);
        if (FMLEnvironment.dist.isClient()) {
            bus.addListener(ClientEvents::doClientStuff);
            bus.addListener(ClientEvents::registerLoader);
            bus.addListener(ClientEvents::particle);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        Util.setStackSize(Items.f_42589_, 16);
        Util.setStackSize(Items.f_42736_, 4);
        Util.setStackSize(Items.f_42739_, 4);
        MinecraftForge.EVENT_BUS.addListener(Events::potionCooldown);
        MinecraftForge.EVENT_BUS.addListener(Events::milkCow);
        MinecraftForge.EVENT_BUS.addListener(Events::afterHit);
        MinecraftForge.EVENT_BUS.addListener(Events::playerBrew);
        MinecraftForge.EVENT_BUS.addListener(Events::canApplyEffect);
        MinecraftForge.EVENT_BUS.addListener(Events::tick);
        ItemStack milkPot = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)milkPot, (Potion)ModPotions.MILK);
        ItemStack splashMilkPot = new ItemStack((ItemLike)Items.f_42736_);
        PotionUtils.m_43549_((ItemStack)splashMilkPot, (Potion)ModPotions.MILK);
        ItemStack lingerMilkPot = new ItemStack((ItemLike)Items.f_42739_);
        PotionUtils.m_43549_((ItemStack)lingerMilkPot, (Potion)ModPotions.MILK);
        BrewingRecipeRegistry.addRecipe((Ingredient)PotionIngredient.create(milkPot), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), (ItemStack)splashMilkPot);
        BrewingRecipeRegistry.addRecipe((Ingredient)PotionIngredient.create(milkPot), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42735_}), (ItemStack)lingerMilkPot);
        DavesPotioneering.strongRecipe(Potions.f_43605_, ModPotions.STRONG_INVISIBILITY);
        HashSet<Block> newSet = new HashSet<Block>(((BlockEntityTypeAcces)BlockEntityType.f_58908_).getValidBlocks());
        newSet.add(ModBlocks.MAGIC_LECTERN);
        ((BlockEntityTypeAcces)BlockEntityType.f_58908_).setValidBlocks(newSet);
        PacketHandler.registerMessages();
        ModCauldronInteractions.bootStrap();
    }

    private void stackAdj(ModConfigEvent e) {
        if (e.getConfig().getModId().equals(MODID)) {
            Util.setStackSize(Items.f_42589_, (Integer)ModConfig.Server.potion_stack_size.get());
            Util.setStackSize(Items.f_42736_, (Integer)ModConfig.Server.splash_potion_stack_size.get());
            Util.setStackSize(Items.f_42739_, (Integer)ModConfig.Server.lingering_potion_stack_size.get());
        }
    }

    protected static void strongRecipe(Potion potion, Potion strong) {
        BrewingRecipeRegistry.addRecipe((Ingredient)PotionIngredient.create(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion)), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)strong));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModConfig.Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ModConfig.Client)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ModConfig.Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (ModConfig.Server)specPair2.getLeft();
    }
}

