/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.block.LayeredReinforcedCauldronBlock;
import tfar.davespotioneering.duck.BrewingStandDuck;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.item.GauntletItem;
import tfar.davespotioneering.item.UmbrellaItem;
import tfar.davespotioneering.menu.AdvancedBrewingStandContainer;
import tfar.davespotioneering.mixin.BrewingStandContainerAccess;

public class Events {
    public static void potionCooldown(PlayerInteractEvent.RightClickItem e) {
        ItemStack stack = e.getItemStack();
        Player player = e.getPlayer();
        if (!player.f_19853_.f_46443_ && stack.m_41720_() instanceof ThrowablePotionItem) {
            player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)ModConfig.Server.potion_throw_cooldown.get()).intValue());
        }
    }

    public static void milkCow(PlayerInteractEvent.EntityInteractSpecific e) {
        Entity clicked = e.getTarget();
        Player player = e.getPlayer();
        if (((Boolean)ModConfig.Server.milk.get()).booleanValue() && clicked instanceof Cow) {
            Cow cow = (Cow)clicked;
            ItemStack itemstack = player.m_21120_(e.getHand());
            if (itemstack.m_41720_() == Items.f_42590_ && !cow.m_6162_()) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                itemstack.m_41774_(1);
                ItemStack milkBottle = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)milkBottle, (Potion)ModPotions.MILK);
                player.m_36356_(milkBottle);
            }
        }
    }

    public static void afterHit(LivingDamageEvent e) {
        Potion potion;
        LivingEntity attacker;
        ItemStack weapon;
        LivingEntity victim = e.getEntityLiving();
        DamageSource source = e.getSource();
        Entity trueSource = source.m_7639_();
        if (trueSource instanceof LivingEntity && (weapon = (attacker = (LivingEntity)trueSource).m_21205_()).m_41720_() instanceof TieredItem && (potion = PotionUtils.m_43579_((ItemStack)weapon)) != Potions.f_43598_) {
            for (MobEffectInstance effectinstance : potion.m_43488_()) {
                victim.m_7292_(new MobEffectInstance(effectinstance.m_19544_(), Math.max(effectinstance.m_19557_() / 8, 1), effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
            }
            LayeredReinforcedCauldronBlock.useCharge(weapon);
        }
    }

    public static void potionBrew(BlockEntity brewingStandTileEntity, ItemStack ingredient) {
        ((BrewingStandDuck)brewingStandTileEntity).addXp(Util.getBrewXp(ingredient));
    }

    public static void heldItemChangeEvent(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof LingeringPotionItem || stack.m_41720_() instanceof SplashPotionItem) {
            player.m_36335_().m_41524_(Items.f_42736_, ((Integer)ModConfig.Server.potion_switch_cooldown.get()).intValue());
            player.m_36335_().m_41524_(Items.f_42739_, ((Integer)ModConfig.Server.potion_switch_cooldown.get()).intValue());
        }
    }

    public static void onEat(Player player, ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        for (MobEffectInstance effectInstance : potion.m_43488_()) {
            player.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), Math.max(effectInstance.m_19557_() / 8, 1), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19575_()));
        }
    }

    public static void playerBrew(PlayerBrewedPotionEvent e) {
        Player player = e.getPlayer();
        if (!player.f_19853_.f_46443_) {
            AbstractContainerMenu container = player.f_36096_;
            Object entity = null;
            if (container instanceof BrewingStandMenu) {
                entity = (BrewingStandBlockEntity)((BrewingStandContainerAccess)container).getBrewingStand();
            } else if (container instanceof AdvancedBrewingStandContainer) {
                entity = ((AdvancedBrewingStandContainer)container).blockEntity;
            }
            if (entity != null) {
                ((BrewingStandDuck)entity).dump(player);
            }
        }
    }

    public static void canApplyEffect(PotionEvent.PotionApplicableEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity.m_21211_().m_41720_() instanceof UmbrellaItem) {
            e.setResult(Event.Result.DENY);
        }
    }

    public static void tick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START && e.side.isServer()) {
            GauntletItem.tickCooldowns((LivingEntity)e.player);
        }
    }
}

