/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.blockentity.PotionInjectorBlockEntity;

public class PotionInjectorBlock
extends Block
implements EntityBlock {
    public static final String TRANS_KEY = "davespotioneering.container.potion_injector";
    public static final Component CONTAINER_NAME = new TranslatableComponent("davespotioneering.container.potion_injector");
    public static final BooleanProperty HAS_GAUNTLET = BooleanProperty.m_61465_((String)"has_gauntlet");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.m_83113_((VoxelShape)BOTTOM_SHAPE, (VoxelShape)EAST_SHAPE, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)BOTTOM_SHAPE, (VoxelShape)SOUTH_SHAPE, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)BOTTOM_SHAPE, (VoxelShape)WEST_SHAPE, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)BOTTOM_SHAPE, (VoxelShape)NORTH_SHAPE, (BooleanOp)BooleanOp.f_82695_)};

    public PotionInjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_GAUNTLET, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_((MenuProvider)worldIn.m_7702_(pos));
        player.m_36220_(Stats.f_12967_);
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).m_122416_()];
    }

    public static void setHasGauntlet(Level worldIn, BlockPos pos, BlockState state, boolean hasBook) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_GAUNTLET, (Comparable)Boolean.valueOf(hasBook)), 3);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HAS_GAUNTLET, FACING});
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent(this.m_7705_() + ".hold_shift.desc"));
        if (Screen.m_96638_()) {
            tooltip.add((Component)this.getShiftDescription().m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)new TranslatableComponent(this.m_7705_() + ".hold_ctrl.desc"));
        if (Screen.m_96637_()) {
            tooltip.add((Component)this.getCtrlDescription().m_130940_(ChatFormatting.GRAY));
        }
    }

    public MutableComponent getShiftDescription() {
        return new TranslatableComponent(this.m_7705_() + ".shift.desc");
    }

    public MutableComponent getCtrlDescription() {
        return new TranslatableComponent(this.m_7705_() + ".ctrl.desc");
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof PotionInjectorBlockEntity) {
                PotionInjectorBlockEntity potionInjectorBlockEntity = (PotionInjectorBlockEntity)blockentity;
                Util.dropContents(pLevel, pPos, potionInjectorBlockEntity.handler.getStacks());
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new PotionInjectorBlockEntity(p_153215_, p_153216_);
    }
}

