/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.blockentity;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import tfar.davespotioneering.Events;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.duck.BrewingStandDuck;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.inv.BrewingHandler;
import tfar.davespotioneering.inv.SidedItemHandler;
import tfar.davespotioneering.menu.AdvancedBrewingStandContainer;

public class AdvancedBrewingStandBlockEntity
extends BlockEntity
implements MenuProvider,
BrewingStandDuck {
    public static final int[] POTIONS = new int[]{0, 1, 2};
    public static final int[] INGREDIENTS = new int[]{3, 4, 5, 6, 7};
    public static final int FUEL = 8;
    public static final int TIME = 200;
    protected int xp;
    public static final int SLOTS = POTIONS.length + INGREDIENTS.length + 1;
    private final BrewingHandler brewingHandler = new BrewingHandler(SLOTS);
    private int brewTime;
    private boolean[] filledSlots;
    private Item ingredientID;
    private int fuel;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return AdvancedBrewingStandBlockEntity.this.brewTime;
                }
                case 1: {
                    return AdvancedBrewingStandBlockEntity.this.fuel;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AdvancedBrewingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    AdvancedBrewingStandBlockEntity.this.fuel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    Map<Direction, LazyOptional<? extends IItemHandler>> handlers = SidedItemHandler.create(this.brewingHandler);

    public AdvancedBrewingStandBlockEntity(BlockPos p_155283_, BlockState p_155284_) {
        this(ModBlockEntityTypes.COMPOUND_BREWING_STAND, p_155283_, p_155284_);
    }

    protected AdvancedBrewingStandBlockEntity(BlockEntityType<?> typeIn, BlockPos p_155283_, BlockState p_155284_) {
        super(typeIn, p_155283_, p_155284_);
    }

    protected Component getDefaultName() {
        return new TranslatableComponent("container.davespotioneering.compound_brewing");
    }

    public static void serverTick(Level p_155286_, BlockPos p_155287_, BlockState p_155288_, AdvancedBrewingStandBlockEntity p_155289_) {
        ItemStack fuelStack = p_155289_.brewingHandler.getStackInSlot(8);
        if (p_155289_.fuel <= 0 && fuelStack.m_41720_() == Items.f_42593_) {
            p_155289_.fuel = 20;
            fuelStack.m_41774_(1);
            p_155289_.m_6596_();
        }
        boolean canBrew = p_155289_.canBrew();
        boolean brewing = p_155289_.brewTime > 0;
        ItemStack ing = (ItemStack)p_155289_.getPriorityIngredient().getRight();
        if (brewing) {
            boolean done;
            --p_155289_.brewTime;
            boolean bl = done = p_155289_.brewTime == 0;
            if (done && canBrew) {
                p_155289_.brewPotions();
                p_155289_.m_6596_();
            } else if (!canBrew) {
                p_155289_.brewTime = 0;
                p_155289_.m_6596_();
            } else if (p_155289_.ingredientID != ing.m_41720_()) {
                p_155289_.brewTime = 0;
                p_155289_.m_6596_();
            }
        } else if (canBrew && p_155289_.fuel > 0) {
            --p_155289_.fuel;
            p_155289_.brewTime = 200;
            p_155289_.ingredientID = ing.m_41720_();
            p_155289_.m_6596_();
        }
        if (!p_155289_.f_58857_.f_46443_) {
            p_155289_.setBottleBlockStates();
        }
    }

    private void setBottleBlockStates() {
        boolean[] aboolean = this.createFilledSlotsArray();
        if (!Arrays.equals(aboolean, this.filledSlots)) {
            this.filledSlots = aboolean;
            BlockState blockstate = this.f_58857_.m_8055_(this.m_58899_());
            if (!(blockstate.m_60734_() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.f_50905_.length; ++i) {
                blockstate = (BlockState)blockstate.m_61124_((Property)BrewingStandBlock.f_50905_[i], (Comparable)Boolean.valueOf(aboolean[i]));
            }
            this.f_58857_.m_7731_(this.f_58858_, blockstate, 2);
        }
    }

    public Pair<Integer, ItemStack> getPriorityIngredient() {
        for (int i = 7; i > 2; --i) {
            ItemStack stack = this.brewingHandler.getStackInSlot(i);
            if (stack.m_41619_() || !this.isThereARecipe(stack)) continue;
            return Pair.of((Object)i, (Object)stack);
        }
        return Pair.of((Object)-1, (Object)ItemStack.f_41583_);
    }

    public boolean isThereARecipe(ItemStack ingredient) {
        if (!ingredient.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(this.brewingHandler.getStacks(), (ItemStack)ingredient, (int[])POTIONS) || ingredient.m_41720_() == Items.f_42455_;
        }
        if (ingredient.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)ingredient)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = this.brewingHandler.getStackInSlot(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.brewingHandler.getStackInSlot(i).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean canBrew() {
        ItemStack itemstack = (ItemStack)this.getPriorityIngredient().getRight();
        if (!itemstack.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(this.brewingHandler.getStacks(), (ItemStack)itemstack, (int[])POTIONS);
        }
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = this.brewingHandler.getStackInSlot(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    private void brewPotions() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.brewingHandler.getStacks())) {
            return;
        }
        Pair<Integer, ItemStack> pair = this.getPriorityIngredient();
        ItemStack ingredient = (ItemStack)pair.getRight();
        Util.brewPotions(this.brewingHandler.getStacks(), ingredient, POTIONS);
        ForgeEventFactory.onPotionBrewed(this.brewingHandler.getStacks());
        Events.potionBrew(this, ingredient);
        BlockPos blockpos = this.m_58899_();
        if (ingredient.hasContainerItem()) {
            ItemStack ingredientContainerItem = ingredient.getContainerItem();
            ingredient.m_41774_(1);
            if (ingredient.m_41619_()) {
                ingredient = ingredientContainerItem;
            } else if (!this.f_58857_.f_46443_) {
                Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)ingredientContainerItem);
            }
        } else {
            ingredient.m_41774_(1);
        }
        this.brewingHandler.setStackInSlot((Integer)pair.getLeft(), ingredient);
        this.f_58857_.m_46796_(1035, blockpos, 0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag items = nbt.m_128469_("Items");
        this.brewingHandler.deserializeNBT(items);
        this.brewTime = nbt.m_128448_("BrewTime");
        this.fuel = nbt.m_128451_("Fuel");
        this.xp = nbt.m_128451_("xp");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128376_("BrewTime", (short)this.brewTime);
        compound.m_128365_("Items", (Tag)this.brewingHandler.serializeNBT());
        compound.m_128405_("Fuel", this.fuel);
        compound.m_128405_("xp", this.xp);
    }

    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new AdvancedBrewingStandContainer(id, playerInventory, this.brewingHandler, this.data, this);
    }

    @Override
    public void addXp(double xp) {
        this.xp = (int)((double)this.xp + xp);
    }

    @Override
    public void dump(Player player) {
        if (this.xp > 0) {
            Util.splitAndSpawnExperience(this.f_58857_, player.m_20182_(), this.xp);
            this.xp = 0;
            this.m_6596_();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    public BrewingHandler getBrewingHandler() {
        return this.brewingHandler;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (Map.Entry<Direction, LazyOptional<? extends IItemHandler>> entry : this.handlers.entrySet()) {
            entry.getValue().invalidate();
        }
    }
}

