/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.block.LayeredReinforcedCauldronBlock;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.init.ModItems;
import tfar.davespotioneering.init.ModPotions;

public class ReinforcedCauldronBlockEntity
extends BlockEntity {
    @Nonnull
    protected Potion potion = Potions.f_43598_;

    public ReinforcedCauldronBlockEntity(BlockPos p_155283_, BlockState p_155284_) {
        this(ModBlockEntityTypes.REINFORCED_CAULDRON, p_155283_, p_155284_);
    }

    public ReinforcedCauldronBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos p_155283_, BlockState p_155284_) {
        super(tileEntityTypeIn, p_155283_, p_155284_);
    }

    @Nonnull
    public Potion getPotion() {
        return this.potion;
    }

    public void setPotion(@Nonnull Potion potion) {
        this.potion = potion;
        this.m_6596_();
    }

    public int getColor() {
        if (!this.potion.m_43488_().isEmpty()) {
            return PotionUtils.m_43559_((Potion)this.potion);
        }
        return BiomeColors.m_108811_((BlockAndTintGetter)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void m_142466_(CompoundTag nbt) {
        this.potion = (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(nbt.m_128461_("potion")));
        super.m_142466_(nbt);
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128359_("potion", this.potion.getRegistryName().toString());
        super.m_183515_(compound);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemStack stack = ((ItemEntity)entity).m_32055_();
            if (stack.m_204117_(ModItems.BLACKLISTED)) {
                return;
            }
            boolean dragon = (Boolean)this.m_58900_().m_61143_((Property)LayeredReinforcedCauldronBlock.DRAGONS_BREATH);
            Util.CoatingType coatingType = Util.CoatingType.getCoatingType(stack);
            BlockState blockState = this.m_58900_();
            int cLevel = (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            if (this.potion == ModPotions.MILK && PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43598_ && !Util.isPotion(stack)) {
                LayeredReinforcedCauldronBlock.removeCoating(blockState, this.f_58857_, this.f_58858_, null, stack);
            } else if (coatingType == Util.CoatingType.FOOD) {
                if (((Boolean)ModConfig.Server.spike_food.get()).booleanValue() && stack.m_41613_() >= 8) {
                    LayeredReinforcedCauldronBlock.handleFoodSpiking(blockState, this.f_58857_, this.f_58858_, null, null, stack);
                }
            } else if (stack.m_41720_() == Items.f_42412_ && cLevel > 0) {
                if (dragon) {
                    LayeredReinforcedCauldronBlock.handleArrowCoating(blockState, this.f_58857_, this.f_58858_, null, null, stack);
                }
            } else if (cLevel == 3 && dragon) {
                if (coatingType == Util.CoatingType.TOOL && !((Boolean)ModConfig.Server.coat_tools.get()).booleanValue()) {
                    return;
                }
                if (coatingType == Util.CoatingType.ANY && !((Boolean)ModConfig.Server.coat_anything.get()).booleanValue() && !stack.m_204117_(ModItems.WHITELISTED)) {
                    return;
                }
                entity.f_19853_.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.8f, 1.0f);
                LayeredReinforcedCauldronBlock.setWaterLevel(this.f_58857_, this.f_58858_, blockState, 2);
                this.scheduleTick();
            }
        }
    }

    private void scheduleTick() {
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), LayeredReinforcedCauldronBlock.brew_speed);
    }
}

