/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class FullBrightModel
extends BakedModelWrapper<BakedModel> {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(@Nonnull CacheKey key) {
            return FullBrightModel.transformQuads(key.base.getQuads(key.state, key.side, key.random, (IModelData)EmptyModelData.INSTANCE), key.textures);
        }
    });
    private final Set<ResourceLocation> textures;
    private final boolean doCaching;
    private Predicate<BlockState> state = null;

    public static void invalidateCache() {
        CACHE.invalidateAll();
    }

    public FullBrightModel(BakedModel base, boolean doCaching, ResourceLocation ... textures) {
        super(base);
        this.textures = new HashSet<ResourceLocation>(Arrays.asList(textures));
        this.doCaching = doCaching;
    }

    public FullBrightModel(BakedModel base, boolean doCaching, Predicate<BlockState> state, ResourceLocation ... textures) {
        super(base);
        this.textures = new HashSet<ResourceLocation>(Arrays.asList(textures));
        this.doCaching = doCaching;
        this.state = state;
    }

    public boolean doesHandlePerspectives() {
        return false;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return ForgeHooksClient.handlePerspective((BakedModel)this.originalModel, (ItemTransforms.TransformType)cameraTransformType, (PoseStack)mat);
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (state == null) {
            return FullBrightModel.transformQuads(this.originalModel.m_6840_(state, null, rand), this.textures);
        }
        if (this.state != null && !this.state.test(state)) {
            return this.originalModel.m_6840_(state, side, rand);
        }
        if (!this.doCaching) {
            return FullBrightModel.transformQuads(this.originalModel.m_6840_(state, side, rand), this.textures);
        }
        return (List)CACHE.getUnchecked((Object)new CacheKey(this.originalModel, this.textures, rand, state, side));
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        if (state == null) {
            return this.originalModel.getQuads(null, side, rand, data);
        }
        if (this.state != null && !this.state.test(state)) {
            return this.originalModel.getQuads(state, side, rand, data);
        }
        if (!this.doCaching) {
            return FullBrightModel.transformQuads(this.originalModel.getQuads(state, side, rand, data), this.textures);
        }
        return (List)CACHE.getUnchecked((Object)new CacheKey(this.originalModel, this.textures, rand, state, side));
    }

    private static List<BakedQuad> transformQuads(List<BakedQuad> oldQuads, Set<ResourceLocation> textures) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(oldQuads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (!textures.contains(quad.m_173410_().m_118413_())) continue;
            quads.set(i, FullBrightModel.transformQuad(quad));
        }
        return quads;
    }

    private static BakedQuad transformQuad(BakedQuad quad) {
        int[] vertexData = (int[])quad.m_111303_().clone();
        int step = vertexData.length / 4;
        vertexData[6] = 0xF000F0;
        vertexData[6 + step] = 0xF000F0;
        vertexData[6 + 2 * step] = 0xF000F0;
        vertexData[6 + 3 * step] = 0xF000F0;
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    private static class CacheKey {
        private final BakedModel base;
        private final Set<ResourceLocation> textures;
        private final Random random;
        private final BlockState state;
        private final Direction side;

        public CacheKey(BakedModel base, Set<ResourceLocation> textures, Random random, BlockState state, Direction side) {
            this.base = base;
            this.textures = textures;
            this.random = random;
            this.state = state;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (cacheKey.side != this.side) {
                return false;
            }
            return this.state.equals(cacheKey.state);
        }

        public int hashCode() {
            return this.state.hashCode() + 31 * (this.side != null ? this.side.hashCode() : 0);
        }
    }

    public static class UnbakedFullBrightModel
    implements IModelGeometry<UnbakedFullBrightModel> {
        private final BlockModel baseModel;

        public UnbakedFullBrightModel(BlockModel baseModel) {
            this.baseModel = baseModel;
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new FullBrightModel(this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, true), false, new ResourceLocation("davespotioneering:item/lit_potioneer_gauntlet_bright"));
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.baseModel.m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

