/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.GauntletItem;
import tfar.davespotioneering.mixin.GuiAccess;

public class GauntletHUD
implements IIngameOverlay {
    public static final String GAUNTLET_ICON_LOC = "textures/gauntlet_icons/";
    static final int TEX_HEIGHT = 41;
    static final int TEX_WIDTH = 121;
    private static Potion activePotion = null;
    private static Potion prePotion = null;
    private static Potion postPotion = null;
    private static final ResourceLocation hud = GauntletHUD.getGauntletIconLoc("hud");
    private static final ResourceLocation unknown = GauntletHUD.getGauntletIconLoc("unknown");
    private static final ResourceLocation turtle_master = GauntletHUD.getGauntletIconLoc("turtle_master");
    public static int x = (Integer)ModConfig.Client.gauntlet_hud_x.get();
    public static int y = (Integer)ModConfig.Client.gauntlet_hud_y.get();
    public static HudPresets preset = (HudPresets)((Object)ModConfig.Client.gauntlet_hud_preset.get());
    public static int[] cooldowns = new int[6];
    public static final Minecraft mc = Minecraft.m_91087_();
    private static boolean forwardCycle = false;
    private static boolean backwardCycle = false;
    private static final int maxCooldown = 40;
    private static int cooldown = 40;

    public static ResourceLocation getGauntletIconLoc(String fileName) {
        return new ResourceLocation("davespotioneering", GAUNTLET_ICON_LOC + fileName + ".png");
    }

    public static void init(Potion activePotion, Potion prePotion, Potion postPotion) {
        GauntletHUD.activePotion = activePotion;
        GauntletHUD.prePotion = prePotion;
        GauntletHUD.postPotion = postPotion;
    }

    private static void renderPotion(Potion potion, PoseStack matrixStack, int x, int y, int cooldown) {
        if (potion == null) {
            return;
        }
        if (potion.m_43488_().isEmpty()) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (potion.m_43488_().size() > 1) {
            if (Registry.f_122828_.m_7981_((Object)potion).toString().contains("turtle_master")) {
                GauntletHUD.bind(turtle_master);
            } else if (mc.m_91098_().m_7165_(GauntletHUD.getGauntletIconLoc(Registry.f_122828_.m_7981_((Object)potion).m_135815_()))) {
                GauntletHUD.bind(GauntletHUD.getGauntletIconLoc(Registry.f_122828_.m_7981_((Object)potion).toString()));
            } else {
                GauntletHUD.bind(unknown);
            }
            GuiComponent.m_93143_((PoseStack)matrixStack, (int)x, (int)y, (int)GauntletHUD.mc.f_91065_.m_93252_(), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        } else {
            MobEffect effect = ((MobEffectInstance)potion.m_43488_().get(0)).m_19544_();
            TextureAtlasSprite sprite = mc.m_91306_().m_118732_(effect);
            GauntletHUD.bind(sprite.m_118414_().m_118330_());
            GuiComponent.m_93200_((PoseStack)matrixStack, (int)x, (int)y, (int)0, (int)18, (int)18, (TextureAtlasSprite)sprite);
        }
        if (cooldown > 0) {
            if (GauntletHUD.mc.f_91066_.f_92125_) {
                Minecraft.m_91087_().f_91062_.m_92750_(matrixStack, "" + cooldown, (float)x, (float)(y - 20), 0xFF0000);
            }
            int w = 18;
            int scale = GauntletHUD.getScaledCooldown(w, cooldown);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)x, (int)(y + w - scale), (int)(x + 18), (int)(y + w), (int)Integer.MAX_VALUE);
        }
    }

    private static void bind(ResourceLocation res) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)res);
    }

    private static int getScaledCooldown(float pixels, float cooldown) {
        float totalCooldown = ((Integer)ModConfig.Server.gauntlet_cooldown.get()).intValue();
        if (totalCooldown != 0.0f) {
            float result = cooldown * pixels / totalCooldown;
            return Math.round(result);
        }
        return 0;
    }

    public static void refreshPosition() {
        x = (Integer)ModConfig.Client.gauntlet_hud_x.get();
        y = (Integer)ModConfig.Client.gauntlet_hud_y.get();
        preset = (HudPresets)((Object)ModConfig.Client.gauntlet_hud_preset.get());
    }

    public static void forwardCycle() {
        forwardCycle = true;
    }

    public static void backwardCycle() {
        backwardCycle = true;
    }

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack g = player.m_21205_();
        if (g.m_41720_() instanceof GauntletItem) {
            int yOffset;
            CompoundTag info = player.m_21205_().m_41784_().m_128469_("info");
            Potion[] potions = GauntletItem.getPotionsFromNBT(info);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GauntletHUD.bind(hud);
            if (preset == HudPresets.ABOVE_HOTBAR) {
                x = (screenWidth - 121) / 2;
                y = screenHeight - Math.min(gui.left_height, gui.right_height) - 41;
                if (((GuiAccess)gui).getToolHighlightTimer() > 0) {
                    y -= 10;
                }
            }
            int xFixed = x;
            int yFixed = y;
            if (forwardCycle) {
                yOffset = 2;
                if (--cooldown <= 0) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                    forwardCycle = false;
                    cooldown = 40;
                }
            } else if (backwardCycle) {
                yOffset = 1;
                if (--cooldown <= 0) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                    backwardCycle = false;
                    cooldown = 40;
                }
            } else {
                yOffset = 0;
            }
            GuiComponent.m_93143_((PoseStack)poseStack, (int)xFixed, (int)yFixed, (int)gui.m_93252_(), (float)0.0f, (float)(1 + 43 * yOffset), (int)121, (int)41, (int)128, (int)128);
            int active = info.m_128451_("activePotionIndex");
            int prev = active > 0 ? active - 1 : 5;
            int next = active < 5 ? active + 1 : 0;
            GauntletHUD.renderPotion(prePotion, poseStack, xFixed + 3, yFixed + 21, cooldowns[prev]);
            GauntletHUD.renderPotion(activePotion, poseStack, xFixed + 51, yFixed + 5, cooldowns[active]);
            GauntletHUD.renderPotion(postPotion, poseStack, xFixed + 99, yFixed + 21, cooldowns[next]);
            if (potions == null) {
                GauntletHUD.init(null, null, null);
                return;
            }
            GauntletHUD.init(potions[0], potions[1], potions[2]);
        }
    }

    public static enum HudPresets {
        TOP_LEFT,
        TOP_RIGHT,
        BTM_LEFT,
        BTM_RIGHT,
        ABOVE_HOTBAR,
        FREE_MOVE;

    }
}

