/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client.model.gecko;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class GeoItemStackRenderer<T extends IAnimatable>
extends BlockEntityWithoutLevelRenderer
implements IGeoRenderer<T> {
    protected final AnimatedGeoModel<T> modelProvider;
    protected ItemStack currentItemStack;
    protected final Function<ResourceLocation, RenderType> renderTypeGetter;
    private final T ianimatable;
    public static final IAnimatable NOTHING = new DummyAnimations();

    public GeoItemStackRenderer(AnimatedGeoModel<T> modelProvider, T ianimatable, BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        this(modelProvider, RenderType::m_110452_, ianimatable, p_172550_, p_172551_);
    }

    public GeoItemStackRenderer(AnimatedGeoModel<T> modelProvider, Function<ResourceLocation, RenderType> renderTypeGetter, T ianimatable, BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
        this.modelProvider = modelProvider;
        this.renderTypeGetter = renderTypeGetter;
        this.ianimatable = ianimatable;
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrices, MultiBufferSource bufferIn, int combinedLightIn, int p_239207_6_) {
        if (transformType == ItemTransforms.TransformType.GUI) {
            matrices.m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            Lighting.m_84930_();
            this.render(matrices, bufferIn, combinedLightIn, stack);
            buffer.m_109911_();
            RenderSystem.m_69482_();
            Lighting.m_84931_();
            matrices.m_85849_();
        } else {
            this.render(matrices, bufferIn, combinedLightIn, stack);
        }
    }

    public void render(PoseStack matrices, MultiBufferSource bufferIn, int packedLightIn, ItemStack itemStack) {
        this.currentItemStack = itemStack;
        GeoModel model = this.getGeoModelProvider().getModel(this.getGeoModelProvider().getModelLocation(this.ianimatable));
        Minecraft mc = Minecraft.m_91087_();
        AnimationEvent itemEvent = new AnimationEvent(this.ianimatable, 0.0f, 0.0f, mc.m_91296_(), false, Collections.singletonList(itemStack));
        this.getGeoModelProvider().setLivingAnimations(this.ianimatable, this.getUniqueID(this.ianimatable), itemEvent);
        matrices.m_85836_();
        matrices.m_85837_(0.0, (double)0.01f, 0.0);
        matrices.m_85837_(0.5, 0.5, 0.5);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(this.ianimatable));
        Color renderColor = this.getRenderColor(this.ianimatable, 0.0f, matrices, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(this.ianimatable, 0.0f, matrices, bufferIn, (VertexConsumer)null, packedLightIn, this.getTextureLocation(this.ianimatable));
        RenderSystem.m_69464_();
        VertexConsumer ivertexbuilder = ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)renderType, (boolean)true, (boolean)this.currentItemStack.m_41790_());
        this.render(model, this.ianimatable, 0.0f, renderType, matrices, null, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        matrices.m_85849_();
    }

    public RenderType getRenderType(T animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return this.renderTypeGetter.apply(textureLocation);
    }

    public void setCurrentRTB(MultiBufferSource rtb) {
    }

    public MultiBufferSource getCurrentRTB() {
        return null;
    }

    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public ResourceLocation getTextureLocation(T instance) {
        return this.getGeoModelProvider().getTextureLocation(instance);
    }

    public static class DummyAnimations
    implements IAnimatable {
        AnimationFactory factory = new AnimationFactory((IAnimatable)this);

        private DummyAnimations() {
        }

        public void registerControllers(AnimationData data) {
            data.addAnimationController(new AnimationController((IAnimatable)this, "null", 0.0f, this::predicate));
        }

        protected <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
            return PlayState.STOP;
        }

        public AnimationFactory getFactory() {
            return this.factory;
        }
    }

    public static class GeoItemModel<T extends IAnimatable>
    extends AnimatedGeoModel<T> {
        protected final ResourceLocation animation;
        protected final ResourceLocation modelLoc;
        protected final ResourceLocation textureLoc;
        private static final ResourceLocation DUMMY = new ResourceLocation("davespotioneering", "animations/animation.dummy.json");

        public static GeoItemModel<IAnimatable> makeClosedUmbrella(DyeColor color) {
            return new GeoItemModel<IAnimatable>(new ResourceLocation("closed_umbrella"), new ResourceLocation("davespotioneering", "closed_" + color.name().toLowerCase(Locale.ROOT) + "_umbrella"), DUMMY);
        }

        public static GeoItemModel<IAnimatable> makeOpenUmbrella(DyeColor color) {
            return new GeoItemModel<IAnimatable>(new ResourceLocation("open_umbrella"), new ResourceLocation("davespotioneering", "open_" + color.name().toLowerCase(Locale.ROOT) + "_umbrella"), DUMMY);
        }

        public static GeoItemModel<IAnimatable> makeClosedUmbrella(String color) {
            return new GeoItemModel<IAnimatable>(new ResourceLocation("closed_umbrella"), new ResourceLocation("davespotioneering", "closed_" + color + "_umbrella"), DUMMY);
        }

        public static GeoItemModel<IAnimatable> makeOpenUmbrella(String color) {
            return new GeoItemModel<IAnimatable>(new ResourceLocation("open_umbrella"), new ResourceLocation("davespotioneering", "open_" + color + "_umbrella"), DUMMY);
        }

        public static GeoItemModel<IAnimatable> makeOpenAgedUmbrella() {
            return new GeoItemModel<IAnimatable>(new ResourceLocation("open_aged_umbrella"), new ResourceLocation("davespotioneering", "open_aged_umbrella"), DUMMY);
        }

        public GeoItemModel(ResourceLocation item) {
            this(item, DUMMY);
        }

        public GeoItemModel(ResourceLocation item, ResourceLocation animation) {
            this(item, item, animation);
        }

        public GeoItemModel(ResourceLocation model, ResourceLocation texture, ResourceLocation animation) {
            this.animation = animation;
            this.modelLoc = new ResourceLocation("davespotioneering", "geo/item/" + model.m_135815_() + ".geo.json");
            this.textureLoc = new ResourceLocation("davespotioneering", "textures/item/" + texture.m_135815_() + ".png");
        }

        public ResourceLocation getModelLocation(T object) {
            return this.modelLoc;
        }

        public ResourceLocation getTextureLocation(T object) {
            return this.textureLoc;
        }

        public ResourceLocation getAnimationFileLocation(T animatable) {
            return this.animation;
        }
    }
}

