/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import tfar.davespotioneering.init.ModParticleTypes;
import tfar.davespotioneering.mixin.ParticleManagerAccess;

public class FastDripParticle
extends TextureSheetParticle {
    private final Fluid fluid;
    protected boolean fullbright;

    private FastDripParticle(ClientLevel world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.1f;
        this.fluid = fluid;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float partialTick) {
        return this.fullbright ? 240 : super.m_6355_(partialTick);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.ageParticle();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.updateMotion();
            if (!this.f_107220_) {
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                BlockPos blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
                FluidState fluidstate = this.f_107208_.m_6425_(blockpos);
                if (fluidstate.m_76152_() == this.fluid && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void ageParticle() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void updateMotion() {
    }

    public static class FallingWaterFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public FallingWaterFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLiquidParticle dripparticle = new FallingLiquidParticle(worldIn, x, y, z, (Fluid)Fluids.f_76193_, (ParticleOptions)ModParticleTypes.TINTED_SPLASH);
            dripparticle.m_108335_(this.spriteSet);
            return dripparticle;
        }
    }

    static class FallingNectarParticle
    extends FastDripParticle {
        private FallingNectarParticle(ClientLevel world, double x, double y, double z, Fluid fluid) {
            super(world, x, y, z, fluid);
            this.f_107225_ = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        }

        @Override
        protected void updateMotion() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    static class FallingLiquidParticle
    extends FallingNectarParticle {
        protected final ParticleOptions particleData;

        private FallingLiquidParticle(ClientLevel world, double x, double y, double z, Fluid fluid, ParticleOptions particleData) {
            super(world, x, y, z, fluid);
            this.particleData = particleData;
        }

        @Override
        protected void updateMotion() {
            if (this.f_107218_) {
                this.m_107274_();
                Particle particle = ((ParticleManagerAccess)Minecraft.m_91087_().f_91061_).$makeParticle(this.particleData, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
                particle.m_107253_(this.f_107227_, this.f_107228_, this.f_107229_);
                Minecraft.m_91087_().f_91061_.m_107344_(particle);
            }
        }
    }

    public static class DrippingWaterFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public DrippingWaterFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping dripparticle = new Dripping(worldIn, x, y, z, (Fluid)Fluids.f_76193_, (ParticleOptions)ModParticleTypes.FAST_FALLING_WATER);
            dripparticle.m_108335_(this.spriteSet);
            return dripparticle;
        }
    }

    public static class Dripping
    extends FastDripParticle {
        private final ParticleOptions particleData;

        Dripping(ClientLevel world, double x, double y, double z, Fluid fluid, ParticleOptions particleData) {
            super(world, x, y, z, fluid);
            this.particleData = particleData;
            this.f_107225_ = 10;
        }

        @Override
        protected void ageParticle() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                Particle particle = ((ParticleManagerAccess)Minecraft.m_91087_().f_91061_).$makeParticle(this.particleData, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
                particle.m_107253_(this.f_107227_, this.f_107228_, this.f_107229_);
                Minecraft.m_91087_().f_91061_.m_107344_(particle);
            }
        }

        @Override
        protected void updateMotion() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }
}

