/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.datagen.assets;

import java.util.Locale;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.SeparatePerspectiveModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import tfar.davespotioneering.init.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "davespotioneering", existingFileHelper);
    }

    protected void registerModels() {
        this.makeOneLayerItem(ModItems.COMPOUND_BREWING_STAND);
        this.makeOneLayerItem(ModItems.REINFORCED_CAULDRON);
        this.makeSimpleBlockItem(ModItems.MAGIC_LECTERN);
        this.makeSimpleBlockItem(ModItems.POTION_INJECTOR);
        this.otherGauntlets();
        this.alchemicalGauntlet();
        for (DyeColor dyeColor : DyeColor.values()) {
            this.classicUmbrella(dyeColor);
        }
        this.umbrella("aged");
        this.umbrella("gilded");
    }

    private void classicUmbrella(DyeColor color) {
        String s = color.name().toLowerCase(Locale.ROOT);
        this.umbrella(s);
    }

    private void umbrella(String s) {
        ItemModelBuilder openRed = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder("open_" + s + "_umbrella")).parent((ModelFile)this.getExistingFile(new ResourceLocation("davespotioneering", "item/open_umbrella")));
        ItemModelBuilder closedRed = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder("closed_" + s + "_umbrella")).parent((ModelFile)this.getExistingFile(new ResourceLocation("davespotioneering", "item/closed_umbrella")));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(s + "_umbrella")).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("builtin/entity")))).texture("particle", this.mcLoc("block/dark_oak_planks"))).guiLight(BlockModel.GuiLight.FRONT)).override().model((ModelFile)openRed).predicate(this.mcLoc("blocking"), 0.0f).end().override().model((ModelFile)closedRed).predicate(this.mcLoc("blocking"), 1.0f).end();
    }

    private void otherGauntlets() {
        this.perspectiveGauntlet("rudimentary_gauntlet");
        this.perspectiveGauntlet("netherite_gauntlet");
    }

    private void perspectiveGauntlet(String name) {
        ItemModelBuilder r3dFile = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/3d/" + name + "_1")).parent((ModelFile)this.getExistingFile(this.modLoc("item/3d/" + name)));
        ItemModelBuilder rSpriteFile = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("sprite/" + name)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", "item/sprite/" + name);
        ((SeparatePerspectiveModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).guiLight(BlockModel.GuiLight.FRONT)).customLoader(SeparatePerspectiveModelBuilder::begin)).base((ModelBuilder)rSpriteFile).perspective(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (ModelBuilder)r3dFile).perspective(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (ModelBuilder)r3dFile).perspective(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (ModelBuilder)r3dFile).perspective(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (ModelBuilder)r3dFile).end();
    }

    private void alchemicalGauntlet() {
        String s = ModItems.POTIONEER_GAUNTLET.getRegistryName().m_135815_();
        ModelFile.ExistingModelFile unlitFile = this.getExistingFile(this.modLoc("item/perspective/" + s));
        ModelFile.ExistingModelFile litFile = this.getExistingFile(this.modLoc("item/perspective/lit_" + s));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(s)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).override().model((ModelFile)unlitFile).predicate(this.mcLoc("active"), 0.0f).end().override().model((ModelFile)litFile).predicate(this.mcLoc("active"), 1.0f).end();
    }

    protected void makeSimpleBlockItem(Item item, ResourceLocation loc) {
        ((ItemModelBuilder)this.getBuilder(item.getRegistryName().toString())).parent((ModelFile)this.getExistingFile(loc));
    }

    protected void makeSimpleBlockItem(Item item) {
        this.makeSimpleBlockItem(item, new ResourceLocation("davespotioneering", "block/" + item.getRegistryName().m_135815_()));
    }

    protected void makeOneLayerItem(Item item, ResourceLocation texture) {
        String path = item.getRegistryName().m_135815_();
        if (this.existingFileHelper.exists(new ResourceLocation(texture.m_135827_(), "item/" + texture.m_135815_()), PackType.CLIENT_RESOURCES, ".png", "textures")) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", new ResourceLocation(texture.m_135827_(), "item/" + texture.m_135815_()));
        } else {
            System.out.println("no texture for " + item + " found, skipping");
        }
    }

    protected void makeOneLayerItem(Item item) {
        ResourceLocation texture = item.getRegistryName();
        this.makeOneLayerItem(item, texture);
    }
}

