/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.datagen.assets;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.LanguageProvider;
import org.codehaus.plexus.util.StringUtils;
import tfar.davespotioneering.client.GauntletHUD;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.init.ModEffects;
import tfar.davespotioneering.init.ModItems;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.item.UmbrellaItem;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(DataGenerator gen) {
        super(gen, "davespotioneering", "en_us");
    }

    protected void addTranslations() {
        this.addEffect(() -> ModEffects.MILK, "Milk");
        this.addPotions();
        this.add("container.davespotioneering.compound_brewing", "Compound Brewing Stand");
        this.add("davespotioneering.container.potion_injector", "Potion Injector");
        this.addBlock(() -> ModBlocks.COMPOUND_BREWING_STAND, "Compound Brewing Stand");
        this.addBlock(() -> ModBlocks.REINFORCED_CAULDRON, "Reinforced Cauldron");
        this.addBlock(() -> ModBlocks.REINFORCED_WATER_CAULDRON, "Reinforced Water Cauldron");
        this.addBlock(() -> ModBlocks.POTION_INJECTOR, "Potion Injector");
        this.addItem(() -> ModItems.POTIONEER_GAUNTLET, ModLangProvider.getNameFromItem(ModItems.POTIONEER_GAUNTLET));
        this.addItem(() -> ModItems.RUDIMENTARY_GAUNTLET, ModLangProvider.getNameFromItem(ModItems.RUDIMENTARY_GAUNTLET));
        this.addItem(() -> ModItems.NETHERITE_GAUNTLET, ModLangProvider.getNameFromItem(ModItems.NETHERITE_GAUNTLET));
        this.add("davespotioneering.gui.moveGauntletHUD", "Use your mouse to drag the Gauntlet HUD wherever you would like or use one of these default positions.");
        this.add("davespotioneering.gui.moveGauntletHUD.preset" + GauntletHUD.HudPresets.TOP_LEFT.ordinal(), "Left Top");
        this.add("davespotioneering.gui.moveGauntletHUD.preset" + GauntletHUD.HudPresets.TOP_RIGHT.ordinal(), "Right Top");
        this.add("davespotioneering.gui.moveGauntletHUD.preset" + GauntletHUD.HudPresets.BTM_LEFT.ordinal(), "Left Bottom");
        this.add("davespotioneering.gui.moveGauntletHUD.preset" + GauntletHUD.HudPresets.BTM_RIGHT.ordinal(), "Right Bottom");
        this.add("davespotioneering.gui.moveGauntletHUD.preset" + GauntletHUD.HudPresets.ABOVE_HOTBAR.ordinal(), "Above Hotbar");
        this.add("davespotioneering.tooltip.gauntlet", "%s %s");
        this.add("davespotioneering.tooltip.gauntlet.withDuration", "%s %s (%s)");
        this.addGroup(ModItems.tab, "Dave's Potioneering");
        ModItems.getAllItems().stream().filter(UmbrellaItem.class::isInstance).forEach(item -> {
            this.addItem(() -> item, "Umbrella");
            this.addDesc((ItemLike)item, "Keeps you from getting wet!");
        });
        this.detailedDescriptions();
    }

    public void detailedDescriptions() {
        this.addShiftDesc((ItemLike)ModBlocks.COMPOUND_BREWING_STAND, "An upgraded stand that eases the tedium of brewing.");
        this.addHoldSDesc((ItemLike)ModBlocks.COMPOUND_BREWING_STAND, "Summary: Hold [Shift]");
        this.addCtrlDescs((ItemLike)ModBlocks.COMPOUND_BREWING_STAND, "- Potions brew at 2x speed", "- More ingredient slots", "- Double potion output (6 potions)");
        this.addHoldCDesc((ItemLike)ModBlocks.COMPOUND_BREWING_STAND, "Features: Hold [CTRL]");
        this.addHoldSDesc((ItemLike)ModBlocks.REINFORCED_CAULDRON, "Summary: Hold [Shift]");
        this.addShiftDesc((ItemLike)ModBlocks.REINFORCED_CAULDRON, "A new cauldron that has some mechanical differences/benefits over the Vanilla one.");
        this.addHoldCDesc((ItemLike)ModBlocks.REINFORCED_CAULDRON, "Features: Hold [CTRL]");
        this.addCtrlDescs((ItemLike)ModBlocks.REINFORCED_CAULDRON, "- Water is not depleted when filling empty bottles.", "- Can be filled with potions. Don't mix different flavors!", "- Can be filled with milk");
        this.addHoldADesc((ItemLike)ModBlocks.REINFORCED_CAULDRON, "Coating: Hold [Alt]");
        this.addAltDescs((ItemLike)ModBlocks.REINFORCED_CAULDRON, "1. Once the Reinforced Cauldron is filled with 3 similar potions and Dragon's Breath, a mixture is made.", "2. Next, throw the item/weapon/tool/arrows you would like to coat into the cauldron.", "3. The liquid will sizzle and evaporate until there is nothing left but the newly coated item.");
        this.addShiftDesc((ItemLike)ModItems.POTIONEER_GAUNTLET, "An alchemical weapon that utilizes potions and brute force in a Netherite knuckle sandwich!");
        this.addHoldSDesc((ItemLike)ModItems.POTIONEER_GAUNTLET, "Summary: Hold [Shift]");
        this.addHoldCDesc((ItemLike)ModItems.POTIONEER_GAUNTLET, "Controls: Hold [Ctrl]");
        this.addCtrlDescs((ItemLike)ModItems.POTIONEER_GAUNTLET, "Shift+RMB - Ignites or extinguishes the internal blaze. (toggles potion usage)", "Shift+Scroll wheel up/down - cycles through one of six potions injected into the gauntlet.", "Shift+Middle Mouse Button - customize Gauntlet HUD");
        this.addShiftDesc((ItemLike)ModBlocks.POTION_INJECTOR, "A workstation necessary for preparing the Potioneer Gauntlet.");
        this.addHoldSDesc((ItemLike)ModBlocks.POTION_INJECTOR, "Summary: Hold [Shift]");
        this.addCtrlDesc((ItemLike)ModBlocks.POTION_INJECTOR, "Use this block to inject Blaze Powder and Lingering Potions into the Potioneer Gauntlet.");
        this.addHoldCDesc((ItemLike)ModBlocks.POTION_INJECTOR, "Functionality: Hold [Ctrl]");
        this.addTooltip("coated_with", "Coated with:");
        this.addTooltip("spiked_with", "Spiked with:");
        this.add("key.davespotioneering.open_config", "Open Config");
        this.add("key.categories.davespotioneering", "Dave's Potioneering");
        this.addConfig("gauntlet_hud_x", "The X Position of the gauntlet hud (left top). You should be using the in-game gui to change this though");
        this.addConfig("gauntlet_hud_y", "The y Position of the gauntlet hud (left top). You should be using the in-game gui to change this though");
        this.addConfig("gauntlet_hud_preset", "You shouldn't change this. Just don't");
    }

    protected void addConfig(String value, String trans) {
        this.add("config." + value, trans);
    }

    protected void addTooltip(String code, String tip) {
        this.add("davespotioneering." + code + ".tooltip", tip);
    }

    protected void addDesc(ItemLike item, String desc) {
        this.add(item.m_5456_().m_5524_() + ".desc", desc);
    }

    protected void addShiftDesc(ItemLike item, String desc) {
        this.add(item.m_5456_().m_5524_() + ".shift.desc", desc);
    }

    protected void addShiftDescs(ItemLike item, String ... descs) {
        for (int i = 0; i < descs.length; ++i) {
            String desc = descs[i];
            this.add(item.m_5456_().m_5524_() + i + ".shift.desc", desc);
        }
    }

    protected void addCtrlDesc(ItemLike item, String desc) {
        this.add(item.m_5456_().m_5524_() + ".ctrl.desc", desc);
    }

    protected void addCtrlDescs(ItemLike item, String ... descs) {
        for (int i = 0; i < descs.length; ++i) {
            String desc = descs[i];
            this.add(item.m_5456_().m_5524_() + i + ".ctrl.desc", desc);
        }
    }

    protected void addAltDesc(ItemLike item, String desc) {
        this.add(item.m_5456_().m_5524_() + ".alt.desc", desc);
    }

    protected void addAltDescs(ItemLike item, String ... descs) {
        for (int i = 0; i < descs.length; ++i) {
            String desc = descs[i];
            this.add(item.m_5456_().m_5524_() + i + ".alt.desc", desc);
        }
    }

    protected void addHoldSDesc(ItemLike item, String desc) {
        this.add(item.m_5456_().m_5524_() + ".hold_shift.desc", desc);
    }

    protected void addHoldCDesc(ItemLike item, String desc) {
        this.add(item.m_5456_().m_5524_() + ".hold_ctrl.desc", desc);
    }

    protected void addHoldADesc(ItemLike item, String desc) {
        this.add(item.m_5456_().m_5524_() + ".hold_alt.desc", desc);
    }

    protected void addGroup(CreativeModeTab group, String name) {
        this.add(group.m_40786_().getString(), name);
    }

    public void addPotions() {
        this.add(ModPotions.MILK.m_43492_(Items.f_42589_.m_5524_() + ".effect."), "Milk Bottle");
        this.add(ModPotions.MILK.m_43492_(Items.f_42736_.m_5524_() + ".effect."), "Splash Milk Bottle");
        this.add(ModPotions.MILK.m_43492_(Items.f_42739_.m_5524_() + ".effect."), "Lingering Milk Bottle");
    }

    public static String getNameFromItem(Item item) {
        return StringUtils.capitaliseAllWords((String)item.m_5524_().split("\\.")[2].replace("_", " "));
    }
}

