/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class PotionIngredient
extends Ingredient {
    private final ItemStack stack;

    protected PotionIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack;
    }

    public static PotionIngredient create(ItemStack stack) {
        return new PotionIngredient(stack);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.stack.m_41720_() == input.m_41720_() && this.stack.areShareTagsEqual(input);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.m_41720_().getRegistryName().toString());
        json.addProperty("count", (Number)this.stack.m_41613_());
        if (this.stack.m_41782_()) {
            json.addProperty("nbt", this.stack.m_41783_().toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<PotionIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public PotionIngredient parse(FriendlyByteBuf buffer) {
            return new PotionIngredient(buffer.m_130267_());
        }

        public PotionIngredient parse(JsonObject json) {
            return new PotionIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(FriendlyByteBuf buffer, PotionIngredient ingredient) {
            buffer.m_130055_(ingredient.stack);
        }
    }
}

