/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.init;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import software.bernie.geckolib3.core.IAnimatable;
import tfar.davespotioneering.client.model.gecko.DoubleGeoItemStackRenderer;
import tfar.davespotioneering.client.model.gecko.GeoItemStackRenderer;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.item.AgedUmbrellaItem;
import tfar.davespotioneering.item.GauntletItem;
import tfar.davespotioneering.item.SimpleGauntletItem;
import tfar.davespotioneering.item.UmbrellaItem;

public class ModItems {
    private static List<Item> MOD_ITEMS;
    public static final CreativeModeTab tab;
    public static final Item COMPOUND_BREWING_STAND;
    public static final Item REINFORCED_CAULDRON;
    public static final Item POTIONEER_GAUNTLET;
    public static final Item NETHERITE_GAUNTLET;
    public static final Item RUDIMENTARY_GAUNTLET;
    public static final Item MAGIC_LECTERN;
    public static final Item POTION_INJECTOR;
    public static final Item WHITE_UMBRELLA;
    public static final Item ORANGE_UMBRELLA;
    public static final Item MAGENTA_UMBRELLA;
    public static final Item LIGHT_BLUE_UMBRELLA;
    public static final Item YELLOW_UMBRELLA;
    public static final Item LIME_UMBRELLA;
    public static final Item PINK_UMBRELLA;
    public static final Item GRAY_UMBRELLA;
    public static final Item LIGHT_GRAY_UMBRELLA;
    public static final Item CYAN_UMBRELLA;
    public static final Item PURPLE_UMBRELLA;
    public static final Item BLUE_UMBRELLA;
    public static final Item BROWN_UMBRELLA;
    public static final Item GREEN_UMBRELLA;
    public static final Item RED_UMBRELLA;
    public static final Item BLACK_UMBRELLA;
    public static final Item GILDED_UMBRELLA;
    public static final Item AGED_UMBRELLA;
    public static final TagKey<Item> BLACKLISTED;
    public static final TagKey<Item> WHITELISTED;

    public static Item.Properties baseUmbrella() {
        return new Item.Properties().m_41491_(tab).m_41503_(300);
    }

    public static void register(RegistryEvent.Register<Item> e) {
        for (Field field : ModItems.class.getFields()) {
            try {
                Object o = field.get(null);
                if (!(o instanceof Item)) continue;
                e.getRegistry().register((IForgeRegistryEntry)((Item)((Item)o).setRegistryName(field.getName().toLowerCase(Locale.ROOT))));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    public static List<Item> getAllItems() {
        if (MOD_ITEMS == null) {
            MOD_ITEMS = Arrays.stream(ModItems.class.getFields()).map(field -> {
                try {
                    return field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).filter(Item.class::isInstance).map(Item.class::cast).collect(Collectors.toList());
        }
        return MOD_ITEMS;
    }

    static {
        tab = new CreativeModeTab("davespotioneering"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)COMPOUND_BREWING_STAND);
            }
        };
        COMPOUND_BREWING_STAND = new BlockItem(ModBlocks.COMPOUND_BREWING_STAND, new Item.Properties().m_41491_(tab));
        REINFORCED_CAULDRON = new BlockItem(ModBlocks.REINFORCED_CAULDRON, new Item.Properties().m_41491_(tab));
        POTIONEER_GAUNTLET = new GauntletItem(new Item.Properties().m_41491_(tab).m_41503_(32));
        NETHERITE_GAUNTLET = new SimpleGauntletItem((Tier)Tiers.NETHERITE, 4, -2.8f, new Item.Properties().m_41491_(tab));
        RUDIMENTARY_GAUNTLET = new SimpleGauntletItem((Tier)Tiers.IRON, 3, -2.8f, new Item.Properties().m_41491_(tab));
        MAGIC_LECTERN = new BlockItem(ModBlocks.MAGIC_LECTERN, new Item.Properties());
        POTION_INJECTOR = new BlockItem(ModBlocks.POTION_INJECTOR, new Item.Properties().m_41491_(tab));
        WHITE_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.WHITE, "classic");
        ORANGE_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.ORANGE, "classic");
        MAGENTA_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.MAGENTA, "classic");
        LIGHT_BLUE_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.LIGHT_BLUE, "classic");
        YELLOW_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.YELLOW, "classic");
        LIME_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.LIME, "classic");
        PINK_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.PINK, "classic");
        GRAY_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.GRAY, "classic");
        LIGHT_GRAY_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.LIGHT_GRAY, "classic");
        CYAN_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.CYAN, "classic");
        PURPLE_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.PURPLE, "classic");
        BLUE_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.BLUE, "classic");
        BROWN_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.BROWN, "classic");
        GREEN_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.GREEN, "classic");
        RED_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.RED, "classic");
        BLACK_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), DyeColor.BLACK, "classic");
        GILDED_UMBRELLA = new UmbrellaItem(ModItems.baseUmbrella(), "gilded", "gilded");
        AGED_UMBRELLA = new AgedUmbrellaItem(ModItems.baseUmbrella(), "aged");
        BLACKLISTED = ItemTags.create((ResourceLocation)new ResourceLocation("davespotioneering", "blacklisted"));
        WHITELISTED = ItemTags.create((ResourceLocation)new ResourceLocation("davespotioneering", "whitelisted"));
    }

    public static class HideISTERsFromServer {
        public static BlockEntityWithoutLevelRenderer createGeoClassicUmbrellaItemStackRenderer(DyeColor color) {
            return HideISTERsFromServer.createGeoClassicUmbrellaItemStackRenderer(color.name().toLowerCase(Locale.ROOT));
        }

        public static BlockEntityWithoutLevelRenderer createGeoClassicUmbrellaItemStackRenderer(String itemName) {
            return new DoubleGeoItemStackRenderer<IAnimatable>(GeoItemStackRenderer.GeoItemModel.makeClosedUmbrella(itemName), GeoItemStackRenderer.GeoItemModel.makeOpenUmbrella(itemName), GeoItemStackRenderer.NOTHING, Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }

        @Nonnull
        public static BlockEntityWithoutLevelRenderer createAgedUmbrellaItemStackRenderer() {
            return new DoubleGeoItemStackRenderer<IAnimatable>(GeoItemStackRenderer.GeoItemModel.makeClosedUmbrella("aged"), GeoItemStackRenderer.GeoItemModel.makeOpenAgedUmbrella(), GeoItemStackRenderer.NOTHING, Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }
    }
}

