/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.inv;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.blockentity.AdvancedBrewingStandBlockEntity;

public class BrewingHandler
extends ItemStackHandler {
    private static final int[] INGREDIENTS_AND_POTIONS;
    private static final int[] FUEL_AND_POTIONS;

    public BrewingHandler(int size) {
        super(size);
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public int getSlotLimit(int slot) {
        return slot < AdvancedBrewingStandBlockEntity.POTIONS.length ? 2 : super.getSlotLimit(slot);
    }

    public int[] getSlotsForFace(Direction side) {
        switch (side) {
            case UP: {
                return AdvancedBrewingStandBlockEntity.INGREDIENTS;
            }
            case DOWN: {
                return INGREDIENTS_AND_POTIONS;
            }
        }
        return FUEL_AND_POTIONS;
    }

    public boolean isItemValid(int index, ItemStack stack) {
        if (ArrayUtils.contains((int[])AdvancedBrewingStandBlockEntity.INGREDIENTS, (int)index)) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
        }
        Item item = stack.m_41720_();
        if (index == 8) {
            return item == Items.f_42593_;
        }
        return Util.isValidInputCountInsensitive(stack);
    }

    static {
        Set ingSet = Arrays.stream(AdvancedBrewingStandBlockEntity.INGREDIENTS).boxed().collect(Collectors.toSet());
        Set potSet = Arrays.stream(AdvancedBrewingStandBlockEntity.POTIONS).boxed().collect(Collectors.toSet());
        Sets.SetView union = Sets.union(ingSet, potSet);
        INGREDIENTS_AND_POTIONS = union.stream().mapToInt(i -> i).toArray();
        HashSet potion_fuel = new HashSet(potSet);
        potion_fuel.add(8);
        FUEL_AND_POTIONS = potion_fuel.stream().mapToInt(i -> i).toArray();
    }
}

