/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.net.PacketHandler;
import tfar.davespotioneering.net.S2CCooldownPacket;

public class GauntletItem
extends SwordItem {
    public static final String ACTIVE = "active";
    public static final String ACTIVE_POTION = "activePotionIndex";
    public static final String BLAZE = "blaze";
    public static final String INFO = "info";
    public static final String COOLDOWNS = "potionCooldownMap";
    public static final String POTIONS = "potions";
    public static final int SLOTS = 6;
    public static final int C_LINES = 3;

    public GauntletItem(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, 4, -2.8f, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            boolean active = stack.m_41784_().m_128471_(ACTIVE);
            int blaze = GauntletItem.getBlaze(stack);
            if (!world.f_46443_ && (blaze > 0 || active)) {
                stack.m_41784_().m_128379_(ACTIVE, !active);
                world.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), active ? ModSoundEvents.GAUNTLET_TURNING_OFF : ModSoundEvents.GAUNTLET_TURNING_ON, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public MutableComponent getCtrlDescriptions(int i) {
        return new TranslatableComponent(this.m_5524_() + i + ".ctrl.desc");
    }

    public int getDamage(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        double blaze = 0.0;
        if (tag != null) {
            CompoundTag info = tag.m_128469_(INFO);
            blaze = info.m_128451_(BLAZE);
        }
        return 32 - (int)blaze;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag info = stack.m_41784_().m_128469_(INFO);
        double blaze = info.m_128451_(BLAZE);
        return blaze > 0.0;
    }

    public int m_142159_(ItemStack stack) {
        return ChatFormatting.GOLD.m_126665_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity victim, LivingEntity attacker) {
        if (stack.m_41720_() instanceof GauntletItem) {
            boolean active;
            CompoundTag info = stack.m_41784_().m_128469_(INFO);
            Potion[] potions = GauntletItem.getPotionsFromNBT(info);
            if (attacker instanceof Player && (active = stack.m_41783_().m_128471_(ACTIVE)) && potions != null && GauntletItem.getCooldownFromPotionByIndex(info.m_128451_(INFO), stack, attacker) <= 0 && info.m_128451_(BLAZE) > 0) {
                Potion potion = potions[0];
                for (MobEffectInstance effectInstance : potion.m_43488_()) {
                    victim.m_7292_(new MobEffectInstance(effectInstance));
                }
                info.m_128405_(BLAZE, info.m_128451_(BLAZE) - 1);
                if (info.m_128451_(BLAZE) == 0) {
                    stack.m_41783_().m_128379_(ACTIVE, false);
                }
                GauntletItem.setPotionCooldownByIndex(info.m_128451_(ACTIVE_POTION), (Integer)ModConfig.Server.gauntlet_cooldown.get(), stack, attacker);
            }
        }
        return super.m_7579_(stack, victim, attacker);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Tuple<List<MobEffectInstance>, List<Potion>> tuple;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".hold_shift.desc"));
        if (Screen.m_96638_()) {
            tooltip.add((Component)this.getShiftDescription().m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".hold_ctrl.desc"));
        if (Screen.m_96637_()) {
            for (int i = 0; i < 3; ++i) {
                tooltip.add((Component)this.getCtrlDescriptions(i).m_130940_(ChatFormatting.GRAY));
            }
        }
        if ((tuple = GauntletItem.getEffectsFromGauntlet(stack)) == null) {
            return;
        }
        if (((List)tuple.m_14418_()).isEmpty()) {
            return;
        }
        tooltip.add((Component)new TextComponent(" "));
        for (MobEffectInstance instance : (List)tuple.m_14418_()) {
            TranslatableComponent product;
            TranslatableComponent effectFormatted = new TranslatableComponent(instance.m_19576_());
            effectFormatted.m_130940_(instance.m_19544_().m_19483_().m_19497_());
            TextComponent amplifier = new TextComponent("");
            if (instance.m_19564_() > 0) {
                amplifier = new TextComponent(String.valueOf(instance.m_19564_()));
            }
            if (instance.m_19557_() > 1) {
                TextComponent duration = new TextComponent(MobEffectUtil.m_19581_((MobEffectInstance)instance, (float)1.0f));
                product = new TranslatableComponent("davespotioneering.tooltip.gauntlet.withDuration", new Object[]{effectFormatted, amplifier, duration});
            } else {
                product = new TranslatableComponent("davespotioneering.tooltip.gauntlet", new Object[]{effectFormatted, amplifier});
            }
            tooltip.add((Component)product);
        }
    }

    public MutableComponent getShiftDescription() {
        return new TranslatableComponent(this.m_5524_() + ".shift.desc");
    }

    public MutableComponent getCtrlDescription() {
        return new TranslatableComponent(this.m_5524_() + ".ctrl.desc");
    }

    @Nullable
    public static Tuple<List<MobEffectInstance>, List<Potion>> getEffectsFromGauntlet(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        ListTag nbts = stack.m_41783_().m_128469_(INFO).m_128437_(POTIONS, 8);
        ArrayList effects = new ArrayList();
        ArrayList<Potion> potions = new ArrayList<Potion>();
        for (Tag inbt : nbts) {
            if (!(inbt instanceof StringTag)) continue;
            StringTag stringNBT = (StringTag)inbt;
            Potion potion = (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(stringNBT.m_7916_()));
            effects.addAll(potion.m_43488_());
            potions.add(potion);
        }
        return new Tuple(effects, potions);
    }

    public static void cycleGauntletForward(Player player) {
        if (player == null) {
            return;
        }
        CompoundTag info = player.m_21205_().m_41784_().m_128469_(INFO);
        ListTag nbts = info.m_128437_(POTIONS, 8);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.m_128451_(ACTIVE_POTION);
        if (++index > 5) {
            index = 0;
        }
        info.m_128405_(ACTIVE_POTION, index);
    }

    public static void cycleGauntletBackward(Player player) {
        if (player == null) {
            return;
        }
        CompoundTag info = player.m_21205_().m_41784_().m_128469_(INFO);
        ListTag nbts = info.m_128437_(POTIONS, 8);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.m_128451_(ACTIVE_POTION);
        if (--index < 0) {
            index = 5;
        }
        info.m_128405_(ACTIVE_POTION, index);
    }

    public static Potion[] getPotionsFromNBT(CompoundTag info) {
        Tag pre;
        ListTag nbts = info.m_128437_(POTIONS, 8);
        if (nbts.isEmpty()) {
            return null;
        }
        int index = info.m_128451_(ACTIVE_POTION);
        if (--index < 0) {
            index = 5;
        }
        if ((pre = nbts.get(index)) == null) {
            return null;
        }
        index += 2;
        Tag post = nbts.get(index %= 6);
        if (post == null) {
            return null;
        }
        Potion activePotion = (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(nbts.get(info.m_128451_(ACTIVE_POTION)).m_7916_()));
        Potion prePotion = (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(pre.m_7916_()));
        Potion postPotion = (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(post.m_7916_()));
        return new Potion[]{activePotion, prePotion, postPotion};
    }

    public static void setPotionCooldownByIndex(int index, int cooldown, ItemStack stack, LivingEntity living) {
        CompoundTag persistent = living.getPersistentData();
        CompoundTag tag = !persistent.m_128441_("davespotioneering") ? new CompoundTag() : persistent.m_128469_("davespotioneering");
        persistent.m_128365_("davespotioneering", (Tag)tag);
        int[] cooldowns = tag.m_128465_(COOLDOWNS);
        if (cooldowns.length == 0) {
            cooldowns = new int[6];
        }
        cooldowns[index] = cooldown;
        tag.m_128385_(COOLDOWNS, cooldowns);
    }

    private static int getCooldownFromPotionByIndex(int indexOfPotion, ItemStack stack, LivingEntity living) {
        CompoundTag tag = living.getPersistentData().m_128469_("davespotioneering");
        int[] cooldowns = tag.m_128465_(COOLDOWNS);
        if (cooldowns.length == 0) {
            return 0;
        }
        return cooldowns[indexOfPotion];
    }

    public static void tickCooldowns(LivingEntity living) {
        CompoundTag tag = living.getPersistentData().m_128469_("davespotioneering");
        int[] cooldowns = tag.m_128465_(COOLDOWNS);
        if (cooldowns.length == 0) {
            return;
        }
        boolean sync = false;
        for (int i = 0; i < cooldowns.length; ++i) {
            if (cooldowns[i] <= 0) continue;
            int n = i;
            cooldowns[n] = cooldowns[n] - 1;
            sync = true;
        }
        if (sync) {
            tag.m_128385_(COOLDOWNS, cooldowns);
            PacketHandler.sendToClient(new S2CCooldownPacket(cooldowns), (ServerPlayer)living);
        }
    }

    public static int getBlaze(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        int blaze = 0;
        if (tag != null) {
            CompoundTag info = tag.m_128469_(INFO);
            blaze = info.m_128451_(BLAZE);
        }
        return blaze;
    }
}

