/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.menu;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.blockentity.AdvancedBrewingStandBlockEntity;
import tfar.davespotioneering.init.ModContainerTypes;
import tfar.davespotioneering.inv.BrewingHandler;

public class AdvancedBrewingStandContainer
extends AbstractContainerMenu {
    private final ContainerData data;
    public AdvancedBrewingStandBlockEntity blockEntity;

    public AdvancedBrewingStandContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, new BrewingHandler(AdvancedBrewingStandBlockEntity.SLOTS), (ContainerData)new SimpleContainerData(2), null);
    }

    public AdvancedBrewingStandContainer(int id, Inventory playerInventory, ItemStackHandler inventory, ContainerData data, AdvancedBrewingStandBlockEntity advancedBrewingStandBlockEntity) {
        super(ModContainerTypes.ADVANCED_BREWING_STAND, id);
        this.data = data;
        this.blockEntity = advancedBrewingStandBlockEntity;
        int potY = 77;
        this.m_38897_((Slot)new PotionSlot((IItemHandler)inventory, 0, 56, potY));
        this.m_38897_((Slot)new PotionSlot((IItemHandler)inventory, 1, 79, potY + 7));
        this.m_38897_((Slot)new PotionSlot((IItemHandler)inventory, 2, 102, potY));
        for (int i = 3; i < 7; ++i) {
            this.m_38897_((Slot)new IngredientSlot((IItemHandler)inventory, i, 22 * i - 20, 17));
        }
        int ing1 = 43;
        this.m_38897_((Slot)new IngredientSlot((IItemHandler)inventory, 7, 79, ing1));
        this.m_38897_((Slot)new FuelSlot((IItemHandler)inventory, 8, 17, ing1));
        this.m_38884_(data);
        int invX = 8;
        int invY = 110;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, invX + j * 18, invY + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, invX + k * 18, invY + 58));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index < AdvancedBrewingStandBlockEntity.SLOTS) {
                if (!this.m_38903_(slotStack, AdvancedBrewingStandBlockEntity.SLOTS, 41, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(slotStack, 0, AdvancedBrewingStandBlockEntity.SLOTS, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, itemstack);
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemstack;
    }

    public int getFuel() {
        return this.data.m_6413_(1);
    }

    public int getBrewTime() {
        return this.data.m_6413_(0);
    }

    public static class PotionSlot
    extends SlotItemHandler {
        public PotionSlot(IItemHandler iItemHandler, int index, int x, int y) {
            super(iItemHandler, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return Util.isValidInputCountInsensitive(stack);
        }

        public int m_6641_() {
            return 2;
        }

        public void m_142406_(Player thePlayer, ItemStack stack) {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            if (thePlayer instanceof ServerPlayer) {
                ForgeEventFactory.onPlayerBrewedPotion((Player)thePlayer, (ItemStack)stack);
                CriteriaTriggers.f_10577_.m_19120_((ServerPlayer)thePlayer, potion);
            }
            super.m_142406_(thePlayer, stack);
        }
    }

    static class IngredientSlot
    extends SlotItemHandler {
        public IngredientSlot(IItemHandler iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() == Items.f_42455_ || BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
        }
    }

    public static class FuelSlot
    extends SlotItemHandler {
        public FuelSlot(IItemHandler iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return FuelSlot.isValidBrewingFuel(stack);
        }

        public static boolean isValidBrewingFuel(ItemStack itemStackIn) {
            return itemStackIn.m_41720_() == Items.f_42593_;
        }

        public int m_6641_() {
            return 64;
        }
    }
}

