/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.menu;

import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import tfar.davespotioneering.init.ModContainerTypes;
import tfar.davespotioneering.inv.PotionInjectorHandler;

public class PotionInjectorMenu
extends AbstractContainerMenu {
    private final ItemStackHandler inventory;
    public static final int BLAZE_CAP = 32;

    public PotionInjectorMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, new PotionInjectorHandler(8));
    }

    public PotionInjectorMenu(int id, Inventory playerInventory, ItemStackHandler inventory) {
        super(ModContainerTypes.ALCHEMICAL_GAUNTLET, id);
        this.inventory = inventory;
        int potY = 77;
        for (int i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, i, 26 + 108 * (i / 3), 18 + 18 * (i % 3)));
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, 6, 80, 32));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, 7, 80, 55));
        int invX = 8;
        int invY = 109;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, invX + j * 18, invY + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, invX + k * 18, invY + 58));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.inventory.getSlots() ? !this.m_38903_(itemstack1, this.inventory.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.inventory.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void handleButton(int button) {
        switch (button) {
            case 0: {
                this.storePotionsAndBlaze();
                break;
            }
            case 1: {
                this.removePotionsAndBlaze();
            }
        }
    }

    private void storePotionsAndBlaze() {
        ItemStack gauntlet = this.inventory.getStackInSlot(6);
        if (!gauntlet.m_41619_()) {
            CompoundTag newNbt = new CompoundTag();
            ListTag nbt1 = new ListTag();
            CompoundTag oldNBT = gauntlet.m_41784_();
            CompoundTag info = oldNBT.m_128469_("info");
            ListTag oldList = info.m_128437_("potions", 8);
            for (int i = 0; i < 6; ++i) {
                Potion oldPotion;
                Potion potion = oldPotion = oldList.isEmpty() ? Potions.f_43598_ : (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(oldList.get(i).m_7916_()));
                if (oldPotion == Potions.f_43598_) {
                    ItemStack potionStack = this.inventory.getStackInSlot(i);
                    nbt1.add((Object)StringTag.m_129297_((String)PotionUtils.m_43579_((ItemStack)potionStack).getRegistryName().toString()));
                    this.inventory.extractItem(i, 1, false);
                    continue;
                }
                nbt1.add((Object)oldList.get(i));
            }
            newNbt.m_128405_("activePotionIndex", 0);
            newNbt.m_128365_("potions", (Tag)nbt1);
            int presentBlaze = info.m_128451_("blaze");
            int blazeInsert = Math.min(32 - presentBlaze, Math.min(32, this.inventory.getStackInSlot(7).m_41613_()));
            newNbt.m_128405_("blaze", blazeInsert + presentBlaze);
            this.inventory.extractItem(7, blazeInsert, false);
            gauntlet.m_41783_().m_128365_("info", (Tag)newNbt);
        }
    }

    private void removePotionsAndBlaze() {
        ItemStack gauntlet = this.inventory.getStackInSlot(6);
        if (!gauntlet.m_41619_()) {
            CompoundTag nbt = gauntlet.m_41783_().m_128469_("info");
            ListTag listNBT = nbt.m_128437_("potions", 8);
            boolean allRemoved = true;
            for (int i = 0; i < listNBT.size(); ++i) {
                Tag inbt = listNBT.get(i);
                Potion potion = (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(inbt.m_7916_()));
                if (potion == Potions.f_43598_) continue;
                ItemStack present = this.inventory.getStackInSlot(i);
                if (present.m_41613_() < this.inventory.getSlotLimit(i)) {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42739_);
                    PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
                    this.inventory.insertItem(i, stack, false);
                    listNBT.set(i, (Tag)StringTag.m_129297_((String)Potions.f_43598_.getRegistryName().toString()));
                    continue;
                }
                allRemoved = false;
            }
            if (allRemoved) {
                nbt.m_128473_("potions");
            }
            int presentBlaze = this.inventory.getStackInSlot(7).m_41613_();
            int maxBlazeRemove = this.inventory.getSlotLimit(7) - presentBlaze;
            int blaze = nbt.m_128451_("blaze");
            int blazeRemove = Math.min(maxBlazeRemove, blaze);
            this.inventory.insertItem(7, new ItemStack((ItemLike)Items.f_42593_, blazeRemove), false);
            if (blaze > blazeRemove) {
                nbt.m_128405_("blaze", blaze - blazeRemove);
            } else {
                nbt.m_128473_("blaze");
            }
        }
    }

    public SoundTy getSound(boolean inject) {
        if (inject) {
            for (int i = 0; i < 6; ++i) {
                if (this.inventory.getStackInSlot(i).m_41619_()) continue;
                return SoundTy.BOTH;
            }
            return this.inventory.getStackInSlot(7).m_41619_() ? SoundTy.NONE : SoundTy.BLAZE;
        }
        ItemStack stack = this.inventory.getStackInSlot(6);
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            CompoundTag info = nbt.m_128469_("info");
            ListTag listNBT = info.m_128437_("potions", 8);
            if (!listNBT.isEmpty()) {
                for (Tag nb : listNBT) {
                    Potion potion = (Potion)Registry.f_122828_.m_7745_(new ResourceLocation(nb.m_7916_()));
                    if (potion == Potions.f_43598_) continue;
                    return SoundTy.BOTH;
                }
            }
            if (info.m_128451_("blaze") > 0) {
                return SoundTy.BLAZE;
            }
        }
        return SoundTy.NONE;
    }

    public static enum SoundTy {
        NONE,
        BLAZE,
        BOTH;

    }
}

