/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.placement;

import com.simibubi.create.foundation.placement.IPlacementHelper;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PlacementOffset {
    private final boolean success;
    private Vec3i pos;
    private Function<BlockState, BlockState> stateTransform;
    private BlockState ghostState;

    private PlacementOffset(boolean success) {
        this.success = success;
        this.pos = BlockPos.f_121853_;
        this.stateTransform = Function.identity();
        this.ghostState = null;
    }

    public static PlacementOffset fail() {
        return new PlacementOffset(false);
    }

    public static PlacementOffset success() {
        return new PlacementOffset(true);
    }

    public static PlacementOffset success(Vec3i pos) {
        return PlacementOffset.success().at(pos);
    }

    public static PlacementOffset success(Vec3i pos, Function<BlockState, BlockState> transform) {
        return PlacementOffset.success().at(pos).withTransform(transform);
    }

    public PlacementOffset at(Vec3i pos) {
        this.pos = pos;
        return this;
    }

    public PlacementOffset withTransform(Function<BlockState, BlockState> stateTransform) {
        this.stateTransform = stateTransform;
        return this;
    }

    public PlacementOffset withGhostState(BlockState ghostState) {
        this.ghostState = ghostState;
        return this;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Vec3i getPos() {
        return this.pos;
    }

    public BlockPos getBlockPos() {
        if (this.pos instanceof BlockPos) {
            return (BlockPos)this.pos;
        }
        return new BlockPos(this.pos);
    }

    public Function<BlockState, BlockState> getTransform() {
        return this.stateTransform;
    }

    public boolean hasGhostState() {
        return this.ghostState != null;
    }

    public BlockState getGhostState() {
        return this.ghostState;
    }

    public boolean isReplaceable(Level world) {
        if (!this.success) {
            return false;
        }
        return world.m_8055_(new BlockPos(this.pos)).m_60767_().m_76336_();
    }

    public InteractionResult placeInWorld(Level world, BlockItem blockItem, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!this.isReplaceable(world)) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        UseOnContext context = new UseOnContext(player, hand, ray);
        BlockPos newPos = new BlockPos(this.pos);
        ItemStack stackBefore = player.m_21120_(hand).m_41777_();
        if (!world.m_7966_(player, newPos)) {
            return InteractionResult.PASS;
        }
        BlockState state = this.stateTransform.apply(blockItem.m_40614_().m_49966_());
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            FluidState fluidState = world.m_6425_(newPos);
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)newPos);
        world.m_46597_(newPos, state);
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snapshot, IPlacementHelper.ID, (Entity)player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            snapshot.restore(true, false);
            return InteractionResult.FAIL;
        }
        BlockState newState = world.m_8055_(newPos);
        SoundType soundtype = newState.getSoundType((LevelReader)world, newPos, (Entity)player);
        world.m_5594_(null, newPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)blockItem));
        newState.m_60734_().m_6402_(world, newPos, newState, (LivingEntity)player, stackBefore);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, newPos, context.m_43722_());
        }
        if (!player.m_7500_()) {
            context.m_43722_().m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }
}

