/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest;

import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import org.jetbrains.annotations.NotNull;

public class CreateTestFunction
extends TestFunction {
    public static final Map<String, CreateTestFunction> NAMES_TO_FUNCTIONS = new HashMap<String, CreateTestFunction>();
    public final String fullName;
    public final String simpleName;

    protected CreateTestFunction(String fullName, String simpleName, String pBatchName, String pTestName, String pStructureName, Rotation pRotation, int pMaxTicks, long pSetupTicks, boolean pRequired, int pRequiredSuccesses, int pMaxAttempts, Consumer<GameTestHelper> pFunction) {
        super(pBatchName, pTestName, pStructureName, pRotation, pMaxTicks, pSetupTicks, pRequired, pRequiredSuccesses, pMaxAttempts, pFunction);
        this.fullName = fullName;
        this.simpleName = simpleName;
        NAMES_TO_FUNCTIONS.put(fullName, this);
    }

    public String m_128075_() {
        return this.simpleName;
    }

    public static Collection<TestFunction> getTestsFrom(Class<?> ... classes) {
        return Stream.of(classes).map(Class::getDeclaredMethods).flatMap(Stream::of).map(CreateTestFunction::of).filter(Objects::nonNull).sorted(Comparator.comparing(TestFunction::m_128075_)).toList();
    }

    @Nullable
    public static TestFunction of(Method method) {
        GameTest gt = method.getAnnotation(GameTest.class);
        if (gt == null) {
            return null;
        }
        Class<?> owner = method.getDeclaringClass();
        GameTestGroup group = owner.getAnnotation(GameTestGroup.class);
        String simpleName = owner.getSimpleName() + "." + method.getName();
        CreateTestFunction.validateTestMethod(method, gt, owner, group, simpleName);
        String structure = "%s:gametest/%s/%s".formatted(group.namespace(), group.path(), gt.m_177046_());
        Rotation rotation = StructureUtils.m_127835_((int)gt.m_177044_());
        String fullName = owner.getName() + "." + method.getName();
        return new CreateTestFunction(fullName, simpleName, gt.m_177043_(), structure, structure, rotation, gt.m_177042_(), gt.m_177047_(), gt.m_177045_(), gt.m_177049_(), gt.m_177048_(), CreateTestFunction.asConsumer(method));
    }

    private static void validateTestMethod(Method method, GameTest gt, Class<?> owner, GameTestGroup group, String simpleName) {
        if (gt.m_177046_().isEmpty()) {
            throw new IllegalArgumentException(simpleName + " must provide a template structure");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(simpleName + " must be static");
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException(simpleName + " must return void");
        }
        if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != CreateGameTestHelper.class) {
            throw new IllegalArgumentException(simpleName + " must take 1 parameter of type CreateGameTestHelper");
        }
        if (group == null) {
            throw new IllegalArgumentException(owner.getName() + " must be annotated with @GameTestGroup");
        }
    }

    private static Consumer<GameTestHelper> asConsumer(Method method) {
        return helper -> {
            try {
                method.invoke(null, helper);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void m_128076_(@NotNull GameTestHelper helper) {
        StructureBlockEntity be = (StructureBlockEntity)helper.m_177347_(BlockPos.f_121853_);
        be.getTileData().m_128359_("CreateTestFunction", this.fullName);
        super.m_128076_((GameTestHelper)CreateGameTestHelper.of(helper));
    }
}

