/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.builtinenchants;

import com.google.common.collect.Lists;
import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGear;
import com.infamous.dungeons_libraries.items.gearconfig.BowGear;
import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGear;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGear;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.common.util.INBTSerializable;

public class BuiltInEnchantments
implements INBTSerializable<CompoundTag> {
    private Map<ResourceLocation, List<EnchantmentInstance>> enchantments = new HashMap<ResourceLocation, List<EnchantmentInstance>>();
    public static final String ENCHANTS_KEY = "BuiltInEnchantments";
    public static final String SOURCE_KEY = "source";
    public static final String ENCHANTMENT_DATA_KEY = "data";

    public BuiltInEnchantments() {
    }

    public BuiltInEnchantments(ItemStack itemStack) {
        IReloadableGear item;
        Item item2 = itemStack.m_41720_();
        if (item2 instanceof MeleeGear) {
            item = (MeleeGear)item2;
            this.enchantments.put(MeleeGearConfigRegistry.GEAR_CONFIG_BUILTIN_RESOURCELOCATION, new ArrayList<EnchantmentInstance>(((MeleeGear)item).getGearConfig().getBuiltInEnchantments()));
        }
        if ((item2 = itemStack.m_41720_()) instanceof BowGear) {
            item = (BowGear)item2;
            this.enchantments.put(MeleeGearConfigRegistry.GEAR_CONFIG_BUILTIN_RESOURCELOCATION, new ArrayList<EnchantmentInstance>(((BowGear)item).getGearConfig().getBuiltInEnchantments()));
        }
        if ((item2 = itemStack.m_41720_()) instanceof CrossbowGear) {
            item = (CrossbowGear)item2;
            this.enchantments.put(MeleeGearConfigRegistry.GEAR_CONFIG_BUILTIN_RESOURCELOCATION, new ArrayList<EnchantmentInstance>(((CrossbowGear)item).getGearConfig().getBuiltInEnchantments()));
        }
        if ((item2 = itemStack.m_41720_()) instanceof ArmorGear) {
            item = (ArmorGear)item2;
            List<EnchantmentInstance> builtInEnchantments = ((ArmorGear)item).getGearConfig().getBuiltInEnchantments().stream().filter(enchantmentInstance -> enchantmentInstance.f_44947_.m_6081_(itemStack)).toList();
            this.enchantments.put(MeleeGearConfigRegistry.GEAR_CONFIG_BUILTIN_RESOURCELOCATION, builtInEnchantments);
        }
    }

    public boolean addBuiltInEnchantment(ResourceLocation source, EnchantmentInstance enchantmentInstance) {
        this.enchantments.computeIfAbsent(source, resourceLocation -> this.enchantments.put((ResourceLocation)resourceLocation, new ArrayList()));
        this.enchantments.get(source).add(enchantmentInstance);
        return true;
    }

    public boolean removeBuiltInEnchantment(ResourceLocation source, Enchantment enchantment) {
        if (!this.enchantments.containsKey(source)) {
            return false;
        }
        this.enchantments.put(source, this.enchantments.get(source).stream().filter(enchantmentInstance -> enchantmentInstance.f_44947_ != enchantment).collect(Collectors.toList()));
        return true;
    }

    public boolean setBuiltInEnchantments(ResourceLocation source, List<EnchantmentInstance> enchantmentInstance) {
        this.enchantments.put(source, new ArrayList<EnchantmentInstance>(enchantmentInstance));
        return true;
    }

    public boolean clearAllBuiltInEnchantments(ResourceLocation source) {
        this.enchantments.remove(source);
        return true;
    }

    public List<EnchantmentInstance> getBuiltInEnchantments(ResourceLocation source) {
        List<EnchantmentInstance> enchantmentInstance = this.enchantments.get(source);
        if (enchantmentInstance == null) {
            return Lists.newArrayList();
        }
        return enchantmentInstance;
    }

    public List<EnchantmentInstance> getAllBuiltInEnchantmentInstances() {
        return this.enchantments.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<ResourceLocation, List<EnchantmentInstance>> getAllBuiltInEnchantmentInstancesPerSource() {
        return this.enchantments;
    }

    public boolean hasBuiltInEnchantment(ResourceLocation source) {
        return !this.getBuiltInEnchantments(source).isEmpty();
    }

    public boolean hasBuiltInEnchantment() {
        return !this.enchantments.isEmpty();
    }

    public boolean hasBuiltInEnchantment(Enchantment enchantment) {
        return this.getAllBuiltInEnchantmentInstances().stream().anyMatch(enchantmentInstance -> enchantmentInstance.f_44947_.equals(enchantment));
    }

    public int getBuiltInItemEnchantmentLevel(Enchantment enchantment) {
        return this.getAllBuiltInEnchantmentInstances().stream().filter(enchantmentInstance -> enchantmentInstance.f_44947_.equals(enchantment)).map(enchantmentInstance -> enchantmentInstance.f_44948_).max(Comparator.naturalOrder()).orElse(0);
    }

    public CompoundTag serializeNBT() {
        if (ModCapabilities.BUILT_IN_ENCHANTMENTS_CAPABILITY == null) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        ListTag listnbt = new ListTag();
        this.getAllBuiltInEnchantmentInstancesPerSource().forEach((resourceLocation, enchantmentInstances) -> {
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128359_(SOURCE_KEY, String.valueOf(resourceLocation));
            ListTag enchantmentListnbt = new ListTag();
            enchantmentInstances.forEach(enchantmentInstance -> {
                CompoundTag enchantmentInstanceNBT = new CompoundTag();
                enchantmentInstanceNBT.m_128359_("id", String.valueOf(enchantmentInstance.f_44947_.getRegistryName()));
                enchantmentInstanceNBT.m_128376_("lvl", (short)enchantmentInstance.f_44948_);
                enchantmentListnbt.add((Object)enchantmentInstanceNBT);
            });
            compoundnbt.m_128365_(ENCHANTMENT_DATA_KEY, (Tag)enchantmentListnbt);
            listnbt.add((Object)compoundnbt);
        });
        tag.m_128365_(ENCHANTS_KEY, (Tag)listnbt);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag listNBT = tag.m_128437_(ENCHANTS_KEY, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundTag compoundnbt = listNBT.m_128728_(i);
            ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)compoundnbt.m_128461_(SOURCE_KEY));
            ListTag enchantmentListnbt = new ListTag();
            Map enchantmentIntegerMap = EnchantmentHelper.m_44882_((ListTag)compoundnbt.m_128437_(ENCHANTMENT_DATA_KEY, 10));
            List<EnchantmentInstance> enchantmentInstanceList = enchantmentIntegerMap.entrySet().stream().map(entry -> new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
            this.setBuiltInEnchantments(resourcelocation, enchantmentInstanceList);
        }
    }
}

