/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.enchantedprojectile;

import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectile;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class AttacherEnchantedProjectile {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Projectile) {
            EnchantedProjectileProvider provider = new EnchantedProjectileProvider();
            event.addCapability(EnchantedProjectileProvider.IDENTIFIER, (ICapabilityProvider)provider);
        }
    }

    private static class EnchantedProjectileProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("dungeons_libraries", "enchanted_projectile");
        private final EnchantedProjectile backend = new EnchantedProjectile();
        private final LazyOptional<EnchantedProjectile> optionalData = LazyOptional.of(() -> this.backend);

        private EnchantedProjectileProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return ModCapabilities.ENCHANTED_PROJECTILE_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

