/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.enchantedprojectile;

import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantments;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class EnchantedProjectile {
    public static final String ENCHANTMENT_DATA_KEY = "EnchantmentInstance";
    private List<EnchantmentInstance> enchantmentDataList = new ArrayList<EnchantmentInstance>();

    public void setEnchantments(ItemStack itemStack) {
        Map itemStackEnchantmentInstance = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        BuiltInEnchantments cap = BuiltInEnchantmentsHelper.getBuiltInEnchantmentsCapability(itemStack);
        Map<Enchantment, Integer> builtInEnchantments = cap.getAllBuiltInEnchantmentInstances().stream().collect(Collectors.groupingBy(enchantmentData -> enchantmentData.f_44947_, Collectors.summingInt(value -> value.f_44948_)));
        builtInEnchantments.forEach((enchantment, integer) -> itemStackEnchantmentInstance.compute(enchantment, (enchantment1, integer1) -> integer1 == null ? integer : integer1 + integer));
        this.enchantmentDataList = itemStackEnchantmentInstance.entrySet().stream().map(entry -> new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
    }

    public int getEnchantmentLevel(Enchantment enchantment) {
        return this.enchantmentDataList.stream().filter(enchantmentData -> enchantmentData.f_44947_ == enchantment).map(enchantmentData -> enchantmentData.f_44948_).findFirst().orElse(0);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag enchantmentListnbt = new ListTag();
        this.enchantmentDataList.forEach(enchantmentData -> {
            CompoundTag enchantmentDataNBT = new CompoundTag();
            enchantmentDataNBT.m_128359_("id", String.valueOf(enchantmentData.f_44947_.getRegistryName()));
            enchantmentDataNBT.m_128376_("lvl", (short)enchantmentData.f_44948_);
            enchantmentListnbt.add((Object)enchantmentDataNBT);
        });
        nbt.m_128365_(ENCHANTMENT_DATA_KEY, (Tag)enchantmentListnbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag tag) {
        Map enchantmentIntegerMap = EnchantmentHelper.m_44882_((ListTag)tag.m_128437_(ENCHANTMENT_DATA_KEY, 10));
        this.enchantmentDataList = enchantmentIntegerMap.entrySet().stream().map(entry -> new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
    }
}

