/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.summon.SummonConfigRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Master
implements INBTSerializable<CompoundTag> {
    private Set<Entity> summonedMobs;
    private List<UUID> summonedMobsUUID = new ArrayList<UUID>();
    private ResourceLocation levelOnLoad;
    private Set<Entity> otherMinions;
    private List<UUID> otherMinionsUUID = new ArrayList<UUID>();
    public static final String LEVEL_KEY = "level";

    public void copyFrom(Master summoner) {
        this.setSummonedMobs(summoner.getSummonedMobs());
    }

    public List<Entity> getAllMinions() {
        ArrayList<Entity> minions = new ArrayList<Entity>();
        minions.addAll(this.getSummonedMobs());
        minions.addAll(this.getOtherMinions());
        return minions;
    }

    public List<Entity> getSummonedMobs() {
        this.summonedMobs = this.initEntities(this.summonedMobs, this.summonedMobsUUID);
        return new ArrayList<Entity>(this.summonedMobs);
    }

    public int getSummonedMobsCost() {
        return this.getSummonedMobs().stream().map(entity -> SummonConfigRegistry.getConfig(entity.m_6095_().getRegistryName()).getCost()).reduce(0, Integer::sum);
    }

    public boolean addSummonedMob(Entity entity) {
        this.summonedMobs = this.initEntities(this.summonedMobs, this.summonedMobsUUID);
        return this.summonedMobs.add(entity);
    }

    public void setSummonedMobs(List<Entity> summonedMobs) {
        this.summonedMobs = new HashSet<Entity>(summonedMobs);
    }

    public void setSummonedMobsUUID(List<UUID> summonedMobsUUID) {
        this.summonedMobsUUID = summonedMobsUUID;
    }

    public void setLevelOnLoad(ResourceLocation levelOnLoad) {
        this.levelOnLoad = levelOnLoad;
    }

    public boolean addMinion(Entity entity) {
        this.otherMinions = this.initEntities(this.otherMinions, this.otherMinionsUUID);
        return this.otherMinions.add(entity);
    }

    public List<Entity> getOtherMinions() {
        this.otherMinions = this.initEntities(this.otherMinions, this.otherMinionsUUID);
        return new ArrayList<Entity>(this.otherMinions);
    }

    public void setOtherMinions(List<Entity> otherMinions) {
        this.otherMinions = new HashSet<Entity>(otherMinions);
    }

    private Set<Entity> initEntities(Set<Entity> entities, List<UUID> entityUUIDs) {
        if (entities != null) {
            return entities;
        }
        if (entityUUIDs != null && this.levelOnLoad != null) {
            if (entityUUIDs.isEmpty()) {
                return new HashSet<Entity>();
            }
            ResourceKey registrykey1 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)this.levelOnLoad);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel world = server.m_129880_(registrykey1);
            if (world != null) {
                entities = entityUUIDs.stream().map(arg_0 -> ((ServerLevel)world).m_8791_(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            }
        } else {
            return new HashSet<Entity>();
        }
        return new HashSet<Entity>(entities);
    }

    public void removeMinion(LivingEntity entityLiving) {
        this.getOtherMinions().remove(entityLiving);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag summoned = new ListTag();
        this.getSummonedMobs().forEach(entity -> {
            CompoundTag mob = new CompoundTag();
            mob.m_128362_("uuid", entity.m_142081_());
            summoned.add((Object)mob);
        });
        nbt.m_128365_("summoned", (Tag)summoned);
        ListTag minions = new ListTag();
        this.getOtherMinions().forEach(entity -> {
            CompoundTag minion = new CompoundTag();
            minion.m_128362_("uuid", entity.m_142081_());
            minions.add((Object)minion);
        });
        nbt.m_128365_("minions", (Tag)minions);
        if (!this.getSummonedMobs().isEmpty()) {
            ResourceLocation location = this.getSummonedMobs().get((int)0).f_19853_.m_46472_().m_135782_();
            nbt.m_128359_(LEVEL_KEY, location.toString());
        } else if (!this.getOtherMinions().isEmpty()) {
            ResourceLocation location = this.getOtherMinions().get((int)0).f_19853_.m_46472_().m_135782_();
            nbt.m_128359_(LEVEL_KEY, location.toString());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag listNBT = tag.m_128437_("summoned", 10);
        ArrayList<UUID> summonedUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundTag compoundnbt = listNBT.m_128728_(i);
            summonedUUIDs.add(compoundnbt.m_128342_("uuid"));
        }
        this.setSummonedMobsUUID(summonedUUIDs);
        ListTag minionsNBT = tag.m_128437_("minions", 10);
        ArrayList<UUID> minionUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < minionsNBT.size(); ++i) {
            CompoundTag compoundnbt = minionsNBT.m_128728_(i);
            minionUUIDs.add(compoundnbt.m_128342_("uuid"));
        }
        if (tag.m_128441_(LEVEL_KEY)) {
            this.setLevelOnLoad(new ResourceLocation(tag.m_128461_(LEVEL_KEY)));
        }
    }
}

