/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Minion
implements INBTSerializable<CompoundTag> {
    private UUID masterUUID;
    private ResourceLocation levelOnLoad;
    private LivingEntity master;
    private boolean summon = false;
    private int minionTimer = 0;
    private boolean temporary = false;
    private boolean revertsOnExpiration = false;
    private boolean goalsAdded = false;
    public static final String MASTER_KEY = "summoner";
    public static final String LEVEL_KEY = "level";
    public static final String SUMMON_FLAG_KEY = "is_summon";
    public static final String TEMPORARY_FLAG_KEY = "is_temporary";
    public static final String REVERTS_ON_EXPIRATION_FLAG_KEY = "reverts_on_expiration";
    public static final String MINION_TIMER_KEY = "minion_timer";

    public LivingEntity getMaster() {
        if (this.master == null && this.masterUUID != null && this.levelOnLoad != null) {
            Entity entity;
            ResourceKey registrykey1 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)this.levelOnLoad);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel world = server.m_129880_(registrykey1);
            if (world != null && (entity = world.m_8791_(this.masterUUID)) instanceof LivingEntity) {
                this.master = (LivingEntity)entity;
            }
        }
        return this.master;
    }

    public void setMaster(LivingEntity master) {
        this.master = master;
        if (master != null) {
            this.masterUUID = master.m_142081_();
            this.levelOnLoad = master.f_19853_.m_46472_().m_135782_();
        } else {
            this.masterUUID = null;
            this.levelOnLoad = null;
        }
    }

    public void setMasterUUID(UUID masterUUID) {
        this.masterUUID = masterUUID;
    }

    public void setLevelOnLoad(ResourceLocation levelOnLoad) {
        this.levelOnLoad = levelOnLoad;
    }

    public boolean isMinion() {
        return this.getMaster() != null;
    }

    public boolean isSummon() {
        return this.getMaster() != null && this.summon;
    }

    public void setSummon(boolean summon) {
        this.summon = summon;
    }

    public void setMinionTimer(int minionTimer) {
        this.minionTimer = minionTimer;
    }

    public int getMinionTimer() {
        return this.minionTimer;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean revertsOnExpiration() {
        return this.revertsOnExpiration;
    }

    public void setRevertsOnExpiration(boolean revertsOnExpiration) {
        this.revertsOnExpiration = revertsOnExpiration;
    }

    public boolean isGoalsAdded() {
        return this.goalsAdded;
    }

    public void setGoalsAdded(boolean goalsAdded) {
        this.goalsAdded = goalsAdded;
    }

    @Nullable
    public CompoundTag serializeNBT() {
        if (ModCapabilities.MINION_CAPABILITY == null) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        if (this.getMaster() != null) {
            tag.m_128362_(MASTER_KEY, this.getMaster().m_142081_());
            ResourceLocation location = this.getMaster().f_19853_.m_46472_().m_135782_();
            tag.m_128359_(LEVEL_KEY, location.toString());
        }
        tag.m_128379_(SUMMON_FLAG_KEY, this.isSummon());
        tag.m_128379_(TEMPORARY_FLAG_KEY, this.isTemporary());
        tag.m_128379_(REVERTS_ON_EXPIRATION_FLAG_KEY, this.revertsOnExpiration());
        tag.m_128405_(MINION_TIMER_KEY, this.getMinionTimer());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128403_(MASTER_KEY)) {
            this.setMasterUUID(tag.m_128342_(MASTER_KEY));
        }
        if (tag.m_128441_(LEVEL_KEY)) {
            this.setLevelOnLoad(new ResourceLocation(tag.m_128461_(LEVEL_KEY)));
        }
        if (tag.m_128441_(SUMMON_FLAG_KEY)) {
            this.setSummon(tag.m_128471_(SUMMON_FLAG_KEY));
        }
        if (tag.m_128441_(TEMPORARY_FLAG_KEY)) {
            this.setTemporary(tag.m_128471_(TEMPORARY_FLAG_KEY));
        }
        if (tag.m_128441_(REVERTS_ON_EXPIRATION_FLAG_KEY)) {
            this.setRevertsOnExpiration(tag.m_128471_(REVERTS_ON_EXPIRATION_FLAG_KEY));
        }
        if (tag.m_128441_(MINION_TIMER_KEY)) {
            this.setMinionTimer(tag.m_128451_(MINION_TIMER_KEY));
        }
    }
}

