/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Minion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class MinionEvents {
    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        Minion cap = MinionMasterHelper.getMinionCapability((Entity)event.getEntityLiving());
        if (cap.isMinion()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        if (entityLiving.f_19853_.f_46443_) {
            return;
        }
        Minion cap = MinionMasterHelper.getMinionCapability((Entity)entityLiving);
        if (cap.isMinion() && cap.isTemporary()) {
            if (cap.getMinionTimer() > 0) {
                cap.setMinionTimer(cap.getMinionTimer() - 1);
            } else if (cap.revertsOnExpiration()) {
                MinionMasterHelper.removeMinion(entityLiving, cap);
            } else {
                entityLiving.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    @SubscribeEvent
    public static void reAddMinionGoals(EntityJoinWorldEvent event) {
        Minion minionCapability;
        List<Entity> minions;
        Master masterCapability;
        Entity entity = event.getEntity();
        if (!event.getWorld().m_5776_() && entity instanceof Mob) {
            MinionMasterHelper.addMinionGoals((Mob)entity);
            masterCapability = MinionMasterHelper.getMasterCapability(entity);
            minions = masterCapability.getAllMinions();
            for (Entity minion : minions) {
                if (!(minion instanceof Mob)) continue;
                minionCapability = MinionMasterHelper.getMinionCapability(minion);
                minionCapability.setMaster((LivingEntity)((Mob)entity));
                MinionMasterHelper.addMinionGoals((Mob)minion);
            }
        }
        if (!event.getWorld().m_5776_() && entity instanceof Player) {
            masterCapability = MinionMasterHelper.getMasterCapability(entity);
            minions = masterCapability.getAllMinions();
            for (Entity minion : minions) {
                if (!(minion instanceof Mob)) continue;
                minionCapability = MinionMasterHelper.getMinionCapability(minion);
                minionCapability.setMaster((LivingEntity)((Player)entity));
                MinionMasterHelper.addMinionGoals((Mob)minion);
            }
        }
    }

    @SubscribeEvent
    public static void checkSummonedMobIsDead(TickEvent.PlayerTickEvent event) {
        Player master = event.player;
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.CLIENT) {
            return;
        }
        if (!master.m_6084_()) {
            return;
        }
        Master masterCap = MinionMasterHelper.getMasterCapability((Entity)event.player);
        MinionEvents.updateAliveList(masterCap);
    }

    @SubscribeEvent
    public static void onMinionDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        Minion minionCapability;
        LivingEntity summoner;
        if (!event.getEntityLiving().f_19853_.m_5776_() && MinionMasterHelper.isMinionEntity((Entity)event.getEntityLiving()) && (summoner = (minionCapability = MinionMasterHelper.getMinionCapability((Entity)(livingEntity = event.getEntityLiving()))).getMaster()) != null) {
            Master masterCap = MinionMasterHelper.getMasterCapability((Entity)summoner);
            MinionEvents.updateAliveList(masterCap);
        }
    }

    private static void updateAliveList(Master masterCap) {
        List<Entity> aliveSummons = masterCap.getSummonedMobs().stream().filter(entity -> entity != null && entity.m_6084_()).collect(Collectors.toList());
        masterCap.setSummonedMobs(aliveSummons);
        List<Entity> aliveMinions = masterCap.getOtherMinions().stream().filter(entity -> entity != null && entity.m_6084_()).collect(Collectors.toList());
        masterCap.setOtherMinions(aliveMinions);
    }
}

